/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.lib.translation.DummyConnector;
import net.sf.okapi.lib.translation.QueryManager;
import net.sf.okapi.lib.translation.ResourceItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryManagerTest {
    private QueryManager qm;
    private LocaleId locSrc = LocaleId.fromString((String)"src");
    private LocaleId locTrg = LocaleId.fromString((String)"trg");

    @Before
    public void setUp() {
        this.qm = new QueryManager();
    }

    @Test
    public void testLanguages() {
        this.qm.setLanguages(this.locSrc, this.locTrg);
        Assert.assertEquals((Object)this.locSrc, (Object)this.qm.getSourceLanguage());
        Assert.assertEquals((Object)this.locTrg, (Object)this.qm.getTargetLanguage());
    }

    @Test
    public void testResources() {
        DummyConnector conn = new DummyConnector();
        int resId = this.qm.addResource((IQuery)conn, "ResNameTest");
        Assert.assertEquals((Object)"ResNameTest", (Object)this.qm.getName(resId));
        ResourceItem item = this.qm.getResource(resId);
        Assert.assertNotNull((Object)item);
        IQuery q = this.qm.getInterface(resId);
        Assert.assertNotNull((Object)q);
    }
}

