/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextUnitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnector
implements IQuery {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected LocaleId srcLoc;
    protected String srcCode;
    protected LocaleId trgLoc;
    protected String trgCode;
    protected QueryResult result;
    protected int current = -1;
    private int weight;
    private int noQueryThreshold = 101;

    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.srcCode = this.toInternalCode(this.srcLoc);
        this.trgCode = this.toInternalCode(this.trgLoc);
    }

    public boolean hasNext() {
        return this.current > -1;
    }

    public QueryResult next() {
        if (this.current > -1) {
            this.current = -1;
            return this.result;
        }
        return null;
    }

    public void clearAttributes() {
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, String value) {
    }

    public void setRootDirectory(String rootDir) {
    }

    public IParameters getParameters() {
        return null;
    }

    public void setParameters(IParameters params) {
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public List<List<QueryResult>> batchQueryText(List<String> plainTexts) {
        LinkedList<TextFragment> fragList = new LinkedList<TextFragment>();
        for (String string : plainTexts) {
            fragList.add(new TextFragment(string));
        }
        return this.batchQuery(fragList);
    }

    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        LinkedList<List<QueryResult>> queriesResults = new LinkedList<List<QueryResult>>();
        for (TextFragment fragment : fragments) {
            this.query(fragment);
            LinkedList<QueryResult> results = new LinkedList<QueryResult>();
            while (this.hasNext()) {
                QueryResult qr = this.next();
                results.add(qr);
            }
            queriesResults.add(results);
        }
        return queriesResults;
    }

    public void leverage(ITextUnit tu) {
        if (tu == null || !tu.getSource().hasText() || !tu.isTranslatable()) {
            return;
        }
        AltTranslationsAnnotation at = null;
        TextContainer trgCont = tu.createTarget(this.getTargetLanguage(), false, 4);
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : tu.getSource().getSegments()) {
            if (!srcSeg.text.hasText(false)) continue;
            Segment ts = null;
            if (trgCont.hasBeenSegmented() ? this.hasAlreadyCandidate(ts = trgSegs.get(srcSeg.getId()), null) : this.hasAlreadyCandidate(null, trgCont)) continue;
            this.query(srcSeg.text);
            while (this.hasNext()) {
                QueryResult qr = this.next();
                TextFragmentUtil.alignAndCopyCodeMetadata((TextFragment)srcSeg.text, (TextFragment)qr.target, (boolean)true, (boolean)true, (CodeMatchStrategy)CodeMatchStrategy.LAX);
                if (trgCont.hasBeenSegmented()) {
                    if (ts == null) {
                        ts = new Segment(srcSeg.id, new TextFragment(""));
                        trgSegs.append(ts);
                        this.LOGGER.warn("Cannot find matching target segment for source id: {}.Creating a new target segment at the end of the target.", (Object)srcSeg.getId());
                    }
                    at = TextUnitUtil.addAltTranslation((Segment)ts, (AltTranslation)qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                    continue;
                }
                at = TextUnitUtil.addAltTranslation((TextContainer)trgCont, (AltTranslation)qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
            }
            if (at == null) continue;
            at.sort();
        }
    }

    private boolean hasAlreadyCandidate(Segment seg, TextContainer tc) {
        AltTranslationsAnnotation ann = null;
        if (seg != null) {
            ann = (AltTranslationsAnnotation)seg.getAnnotation(AltTranslationsAnnotation.class);
        } else if (tc != null) {
            ann = (AltTranslationsAnnotation)tc.getAnnotation(AltTranslationsAnnotation.class);
        }
        if (ann == null) {
            return false;
        }
        AltTranslation alt = ann.getFirst();
        if (alt == null) {
            return false;
        }
        return alt.getCombinedScore() >= this.noQueryThreshold;
    }

    public void batchLeverage(List<ITextUnit> tus) {
        for (ITextUnit tu : tus) {
            this.leverage(tu);
        }
    }

    public void setNoQueryThreshold(int noQueryThreshold) {
        this.noQueryThreshold = noQueryThreshold;
    }

    public int getNoQueryThreshold() {
        return this.noQueryThreshold;
    }

    protected void leverageUsingBatchQuery(ITextUnit tu) {
        if (tu == null || !tu.getSource().hasText() || !tu.isTranslatable()) {
            return;
        }
        ArrayList<ITextUnit> tuList = new ArrayList<ITextUnit>();
        tuList.add(tu);
        this.batchLeverageUsingBatchQuery(tuList);
    }

    protected void batchLeverageUsingBatchQuery(List<ITextUnit> tuList) {
        ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
        ArrayList<String> fragsIds = new ArrayList<String>();
        for (ITextUnit tu : tuList) {
            if (tu == null || !tu.getSource().hasText() || !tu.isTranslatable()) continue;
            ISegments trgSegs = null;
            TextContainer trgCont = tu.getTarget(this.getTargetLanguage());
            if (trgCont != null) {
                trgSegs = trgCont.getSegments();
            }
            for (Segment srcSeg : tu.getSource().getSegments()) {
                Segment ts;
                if (trgSegs != null && trgCont.hasBeenSegmented() ? this.hasAlreadyCandidate(ts = trgSegs.get(srcSeg.getId()), null) : this.hasAlreadyCandidate(null, trgCont)) continue;
                frags.add(srcSeg.text);
                fragsIds.add(tu.getId() + "_" + srcSeg.getId());
            }
        }
        List<Object> allResults = new ArrayList();
        if (frags.size() >= 1) {
            this.LOGGER.trace("Starting query for: {}", (Object)frags.toString());
            allResults = this.batchQuery(frags);
        }
        if (allResults.size() <= 0) {
            return;
        }
        int transIndex = -1;
        for (ITextUnit tu : tuList) {
            if (!tu.isTranslatable()) continue;
            TextContainer trgCont = tu.createTarget(this.getTargetLanguage(), false, 4);
            ISegments trgSegs = trgCont.getSegments();
            for (Segment srcSeg : tu.getSource().getSegments()) {
                if (!fragsIds.contains(tu.getId() + "_" + srcSeg.getId())) continue;
                List resList = null;
                try {
                    resList = (List)allResults.get(++transIndex);
                }
                catch (IndexOutOfBoundsException e) {
                    this.LOGGER.error("Couldn't find query result for segment at index {}: {}", (Object)transIndex, (Object)srcSeg.text.toText());
                    continue;
                }
                AltTranslationsAnnotation at = null;
                for (QueryResult qr : resList) {
                    TextFragmentUtil.alignAndCopyCodeMetadata((TextFragment)srcSeg.text, (TextFragment)qr.target, (boolean)true, (boolean)true, (CodeMatchStrategy)CodeMatchStrategy.LAX);
                    if (trgCont.hasBeenSegmented()) {
                        Segment ts = trgSegs.get(srcSeg.getId());
                        if (ts == null) {
                            ts = new Segment(srcSeg.id, new TextFragment(""));
                            trgSegs.append(ts);
                        }
                        at = TextUnitUtil.addAltTranslation((Segment)ts, (AltTranslation)qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                        continue;
                    }
                    at = TextUnitUtil.addAltTranslation((TextContainer)trgCont, (AltTranslation)qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                }
                if (at == null) continue;
                at.sort();
            }
        }
    }

    protected String toInternalCode(LocaleId locId) {
        return locId.toString();
    }
}

