/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.QueryUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryUtilTest {
    private QueryUtil qu;
    private GenericContent fmt;

    @Before
    public void setUp() {
        this.qu = new QueryUtil();
        this.fmt = new GenericContent();
    }

    @Test
    public void testEmptyFragment() {
        TextFragment tf = new TextFragment();
        Assert.assertEquals((Object)"", (Object)this.qu.separateCodesFromText(tf));
        Assert.assertEquals((Object)"", (Object)this.qu.createNewFragmentWithCodes("").toText());
    }

    @Test
    public void testFragmentWithoutCodes() {
        TextFragment tf = new TextFragment("text");
        Assert.assertEquals((Object)"text", (Object)this.qu.separateCodesFromText(tf));
        Assert.assertEquals((Object)"new", (Object)this.qu.createNewFragmentWithCodes("new").toText());
    }

    @Test
    public void testFragmentWithCodes() {
        TextFragment tf = this.makeFragment();
        Assert.assertEquals((Object)"a & < > \" ' <b>bold</b> t <br/> z <i> q", (Object)tf.toText());
        Assert.assertEquals((Object)"a & < > \" ' bold t  z  q", (Object)this.qu.separateCodesFromText(tf));
        Assert.assertEquals((Object)"new<b></b><br/><i>", (Object)this.qu.createNewFragmentWithCodes("new").toText());
    }

    @Test
    public void testToHTML() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        Assert.assertEquals((Object)"a &amp; &lt; > \" ' <u id='1'>bold</u> t <br id='p2'/> z <br id='b3'/> q", (Object)htmlText);
    }

    @Test
    public void testFromSameHTML() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertTrue((resFrag.compareTo(tf, false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((resFrag.compareTo(tf, true) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFromModifiedHTML() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        codedText = codedText.toUpperCase();
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"A & < > \" ' <b>BOLD</b> T <br/> Z <i> Q", (Object)resFrag.toText());
    }

    @Test
    public void testNewTextFragmentFromSameHTML() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        TextFragment resFrag = this.qu.fromCodedHTMLToFragment(htmlText, null);
        Assert.assertTrue((resFrag.compareTo(tf, false) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleHTMLWithCorrection() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        Assert.assertEquals((Object)"a &amp; &lt; > \" ' <u id='1'>bold</u> t <br id='p2'/> z <br id='b3'/> q", (Object)htmlText);
        htmlText = "a <u id='1'>b</u> c";
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"a <1>b</1> c<2/><b3/>", (Object)this.fmt.setContent(resFrag).toString());
        Assert.assertEquals((Object)"a <b>b</b> c<br/><i>", (Object)resFrag.toText());
    }

    @Test
    public void testFromSameHTMLComplex() {
        TextFragment tf = this.makeComplexFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"t1<1><2>bs1</2></1>t2<3>b1</3>", (Object)this.fmt.setContent(resFrag).toString());
    }

    @Test
    public void testFromHTMLComplexWithMovedCodes() {
        TextFragment tf = this.makeComplexFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        Assert.assertEquals((Object)"t1<u id='1'><u id='2'>bs1</u></u>t2<u id='3'>b1</u>", (Object)htmlText);
        htmlText = "t1<u id='2'><u id='3'><u id='1'>t2</u></u>t3</u>";
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"t1<2><3><1>t2</1></3>t3</2>", (Object)this.fmt.setContent(resFrag).toString());
        Assert.assertEquals((Object)"t1<u><b><b>t2</b></b>t3</u>", (Object)resFrag.toText());
    }

    @Test
    public void testFromHTMLComplexWithMovedCodesWithCorrection() {
        TextFragment tf = this.makeComplexFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        Assert.assertEquals((Object)"t1<u id='1'><u id='2'>bs1</u></u>t2<u id='3'>b1</u>", (Object)htmlText);
        htmlText = "t1<u id='2'><u id='1'>t2</u>t3</u>";
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"t1<2><1>t2</1>t3</2><3></3>", (Object)this.fmt.setContent(resFrag).toString());
        Assert.assertEquals((Object)"t1<u><b>t2</b>t3</u><b></b>", (Object)resFrag.toText());
    }

    @Test
    public void testWithEscapes() {
        TextFragment tf = this.makeFragment();
        String htmlText = this.qu.toCodedHTML(tf);
        htmlText = htmlText + "&aacute;&amp;&#39;&#x0152;&apos;";
        String codedText = this.qu.fromCodedHTML(htmlText, tf, true);
        TextFragment resFrag = new TextFragment(codedText, tf.getCodes());
        Assert.assertEquals((Object)"a & < > \" ' <b>bold</b> t <br/> z <i> q\u00e1&'\u0152'", (Object)resFrag.toText());
    }

    private TextFragment makeFragment() {
        TextFragment tf = new TextFragment("a & < > \" ' ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" t ");
        tf.append(TextFragment.TagType.PLACEHOLDER, null, "<br/>");
        tf.append(" z ");
        tf.append(TextFragment.TagType.OPENING, "i", "<i>");
        tf.append(" q");
        return tf;
    }

    private TextFragment makeComplexFragment() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "s", "<u>");
        tf.append("bs1");
        tf.append(TextFragment.TagType.CLOSING, "s", "</u>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("b1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        return tf;
    }
}

