/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.lib.terminology.BaseEntry;
import net.sf.okapi.lib.terminology.LangEntry;

public class ConceptEntry
extends BaseEntry {
    private String id;
    private Map<LocaleId, LangEntry> langs = new HashMap<LocaleId, LangEntry>();

    public ConceptEntry() {
    }

    public ConceptEntry(String source, String target, LocaleId srcLocale, LocaleId trgLocale) {
        this();
        this.addTerm(srcLocale, source);
        this.addTerm(trgLocale, target);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean hasLocale(LocaleId locId) {
        return this.langs.get(locId) != null;
    }

    public LangEntry getEntries(LocaleId locId) {
        return this.langs.get(locId);
    }

    public void addTerm(LocaleId locId, String term) {
        LangEntry lent = this.getEntries(locId);
        if (lent == null) {
            lent = new LangEntry(locId);
            this.langs.put(locId, lent);
        }
        lent.addTerm(term);
    }

    public void addLangEntry(LangEntry lent) {
        this.langs.put(lent.getLocale(), lent);
    }

    public void removeEntries(LocaleId locId) {
        this.langs.remove(locId);
    }
}

