/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.tbx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.LangEntry;
import net.sf.okapi.lib.terminology.TermEntry;
import net.sf.okapi.lib.terminology.tbx.TBXReader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TBXReaderTest {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private LocaleId locHU = LocaleId.fromString((String)"hu");
    private LocaleId locTR = LocaleId.fromString((String)"tr");
    private FileLocation location = FileLocation.fromClass(TBXReaderTest.class);

    @Test
    public void testSimpleTBX() {
        String snippet = "<?xml version='1.0'?><!DOCTYPE martif SYSTEM \"TBXcoreStructV02.dtd\"><martif type=\"TBX\" xml:lang=\"en\"><martifHeader><fileDesc><sourceDesc><p>From an Oracle corporation termbase</p></sourceDesc></fileDesc><encodingDesc><p type=\"XCSURI\">http://www.lisa.org/fileadmin/standards/tbx/TBXXCSV02.XCS</p></encodingDesc></martifHeader><text><body><termEntry id=\"eid1\"><descrip type=\"subjectField\">manufacturing</descrip><descrip type=\"definition\">def text</descrip><langSet xml:lang=\"en\"><tig><term id=\"eid1-en1\">en text</term><termNote type=\"partOfSpeech\">noun-en</termNote></tig></langSet><langSet xml:lang=\"hu\"><tig><term id=\"eid1-hu1\">hu <hi>special</hi> text</term><termNote type=\"partOfSpeech\">noun-hu</termNote></tig></langSet></termEntry><termEntry id=\"ent2\"><langSet xml:lang=\"en\"><ntig><termGrp><term id=\"ent2-1\">en text2</term></termGrp></ntig></langSet><langSet xml:lang=\"fr\"><tig><term id=\"ent2-2\">fr text2</term></tig></langSet></termEntry></body></text></martif>";
        List<ConceptEntry> list = this.getConcepts(snippet, null);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)2L, (long)list.size());
        ConceptEntry gent = list.get(0);
        Assert.assertEquals((Object)"eid1", (Object)gent.getId());
        Assert.assertTrue((boolean)gent.hasLocale(this.locEN));
        LangEntry lent = gent.getEntries(this.locEN);
        TermEntry tent = lent.getTerm(0);
        Assert.assertEquals((Object)"eid1-en1", (Object)tent.getId());
        Assert.assertEquals((Object)"en text", (Object)tent.getText());
        Assert.assertTrue((boolean)gent.hasLocale(this.locHU));
        lent = gent.getEntries(this.locHU);
        tent = lent.getTerm(0);
        Assert.assertEquals((Object)"eid1-hu1", (Object)tent.getId());
        Assert.assertEquals((Object)"hu special text", (Object)tent.getText());
        gent = list.get(1);
        Assert.assertTrue((boolean)gent.hasLocale(this.locFR));
        lent = gent.getEntries(this.locFR);
        tent = lent.getTerm(0);
        Assert.assertEquals((Object)"ent2-2", (Object)tent.getId());
        Assert.assertEquals((Object)"fr text2", (Object)tent.getText());
    }

    @Test
    public void testNoTerms() {
        String snippet = "<?xml version='1.0'?><!DOCTYPE martif SYSTEM \"TBXcoreStructV02.dtd\"><martif type=\"TBX\" xml:lang=\"en\"><martifHeader><fileDesc><sourceDesc><p>From an Oracle corporation termbase</p></sourceDesc></fileDesc><encodingDesc><p type=\"XCSURI\">http://www.lisa.org/fileadmin/standards/tbx/TBXXCSV02.XCS</p></encodingDesc></martifHeader><text><body></body></text></martif>";
        List<ConceptEntry> list = this.getConcepts(snippet, null);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testEncoding() {
        File file = this.location.in("/test02_win1254.tbx").asFile();
        List<ConceptEntry> list = this.getConcepts(null, file);
        Assert.assertEquals((long)1L, (long)list.size());
        ConceptEntry cent = list.get(0);
        Assert.assertEquals((Object)"id1", (Object)cent.getId());
        Assert.assertEquals((Object)"term with: \u00e9\u00e1 and \u0130\u0131", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"tr term with: \u00e9\u00e1 and \u0130\u0131", (Object)cent.getEntries(this.locTR).getTerm(0).getText());
    }

    @Test
    public void testFromFiles() {
        File file = this.location.in("/test01.tbx").asFile();
        List<ConceptEntry> list = this.getConcepts(null, file);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"eid-Oracle-67", (Object)list.get(0).getId());
        file = this.location.in("/sdl_tbx.tbx").asFile();
        list = this.getConcepts(null, file);
        Assert.assertEquals((long)223L, (long)list.size());
        Assert.assertEquals((Object)"c228", (Object)list.get(list.size() - 1).getId());
        file = this.location.in("/ibm_tbx.tbx").asFile();
        list = this.getConcepts(null, file);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"c5", (Object)list.get(list.size() - 1).getId());
        file = this.location.in("/maryland.tbx").asFile();
        list = this.getConcepts(null, file);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"eid-VocCod-211.01", (Object)list.get(list.size() - 1).getId());
        file = this.location.in("/medtronic_TBX.tbx").asFile();
        list = this.getConcepts(null, file);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"c7333", (Object)list.get(list.size() - 1).getId());
        file = this.location.in("/oracle_TBX.tbx").asFile();
        list = this.getConcepts(null, file);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"c2", (Object)list.get(list.size() - 1).getId());
    }

    List<ConceptEntry> getConcepts(String snippet, File file) {
        try {
            ArrayList<ConceptEntry> list = new ArrayList<ConceptEntry>();
            TBXReader tbx = new TBXReader();
            if (file == null) {
                ByteArrayInputStream is = new ByteArrayInputStream(snippet.getBytes(StandardCharsets.UTF_8));
                tbx.open((InputStream)is);
            } else {
                tbx.open(file);
            }
            while (tbx.hasNext()) {
                list.add(tbx.next());
            }
            tbx.close();
            return list;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OkapiException(e.getMessage());
        }
    }
}

