/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.TermHit;
import net.sf.okapi.lib.terminology.simpletb.Parameters;
import net.sf.okapi.lib.terminology.simpletb.SimpleTBConnector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GlossaryTest {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;

    @Test
    public void testTermAccess() {
        ConceptEntry cent = new ConceptEntry();
        Assert.assertFalse((boolean)cent.hasLocale(this.locEN));
        cent.addTerm(this.locEN, "test-en");
        Assert.assertTrue((boolean)cent.hasLocale(this.locEN));
        Assert.assertEquals((Object)"test-en", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        cent.removeEntries(this.locFR);
        Assert.assertTrue((boolean)cent.hasLocale(this.locEN));
        cent.removeEntries(this.locEN);
        Assert.assertFalse((boolean)cent.hasLocale(this.locEN));
    }

    @Test
    public void testTBAccess() {
        SimpleTBConnector ta = new SimpleTBConnector();
        Parameters params = ta.getParameters();
        params.setSourceLocale(this.locEN);
        params.setTargetLocale(this.locFR);
        ta.open();
        ta.addEntry("watch", "montre");
        ta.addEntry("time", "temps");
        TextFragment srcFrag = new TextFragment("This watch shows a time");
        List found1 = ta.getExistingTerms(srcFrag, this.locEN, this.locFR);
        Assert.assertEquals((long)2L, (long)found1.size());
        Assert.assertEquals((Object)"watch", (Object)((TermHit)found1.get((int)0)).sourceTerm.getText());
        Assert.assertEquals((Object)"time", (Object)((TermHit)found1.get((int)1)).sourceTerm.getText());
        TextFragment trgFrag = new TextFragment("Cette montre marque une heure");
        List found2 = ta.getExistingTerms(trgFrag, this.locFR, this.locEN);
        Assert.assertEquals((long)1L, (long)found2.size());
        Assert.assertEquals((Object)"montre", (Object)((TermHit)found2.get((int)0)).sourceTerm.getText());
        ta.close();
    }

    @Test
    public void testGetExistingStrings() {
        SimpleTBConnector ta = new SimpleTBConnector();
        Parameters params = ta.getParameters();
        params.setSourceLocale(this.locEN);
        params.setTargetLocale(this.locFR);
        ta.open();
        ta.addEntry("src", "trg");
        ta.addEntry("src2", "trg2");
        ta.addEntry("Src1 src2", "Trg1 trg2");
        ta.addEntry("src5", "trg5");
        ta.initializeSearch(true, false);
        TextFragment srcFrag = new TextFragment(">src2< and Src1 src2. Also: WithiWordsrcWord");
        List found1 = ta.getExistingStrings(srcFrag, this.locEN, this.locFR);
        Assert.assertEquals((long)2L, (long)found1.size());
        Assert.assertEquals((Object)"Src1 src2", (Object)((TermHit)found1.get((int)0)).sourceTerm.getText());
        Assert.assertEquals((Object)"src2", (Object)((TermHit)found1.get((int)1)).sourceTerm.getText());
    }
}

