/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.tsv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.tsv.TSVReader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TSVReaderTest {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private FileLocation location = FileLocation.fromClass(TSVReaderTest.class);

    @Test
    public void testSimpleTSV() {
        String snippet = "source 1\ttarget 1\nsource 2\ttarget 2\tmore\nline without tab\n   \nsource 3\ttarget 3\n";
        List<ConceptEntry> list = this.getConcepts(snippet, null, this.locEN, this.locFR);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)3L, (long)list.size());
        ConceptEntry cent = list.get(0);
        Assert.assertEquals((Object)"source 1", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 1", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(2);
        Assert.assertEquals((Object)"source 3", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 3", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
    }

    @Test
    public void testFromFiles() {
        File file = this.location.in("/test01.tsv").asFile();
        List<ConceptEntry> list = this.getConcepts(null, file, this.locEN, this.locFR);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"target 3", (Object)list.get(2).getEntries(this.locFR).getTerm(0).getText());
    }

    @Test
    public void testEncoding() {
        File file = this.location.in("/test02_utf16be.tsv").asFile();
        List<ConceptEntry> list = this.getConcepts(null, file, this.locEN, this.locFR);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"\u00e9\u00df\u00d1\uffe6 target 2", (Object)list.get(1).getEntries(this.locFR).getTerm(0).getText());
    }

    List<ConceptEntry> getConcepts(String snippet, File file, LocaleId srcLoc, LocaleId trgLoc) {
        try {
            ArrayList<ConceptEntry> list = new ArrayList<ConceptEntry>();
            TSVReader tsv = new TSVReader(srcLoc, trgLoc);
            if (file == null) {
                ByteArrayInputStream is = new ByteArrayInputStream(snippet.getBytes("UTF-8"));
                tsv.open((InputStream)is);
            } else {
                tsv.open(file);
            }
            while (tsv.hasNext()) {
                list.add(tsv.next());
            }
            tsv.close();
            return list;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OkapiException(e.getMessage());
        }
    }
}

