/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.csv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.csv.CSVReader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CSVReaderTest {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private FileLocation location = FileLocation.fromClass(CSVReaderTest.class);

    @Test
    public void testSimpleCSV() {
        String snippet = "source 1,target 1\n,target 2\ntarget1,\n,\n  source 2  ,  target 2  \n\"source 3\",\"target 3\"\n\" source 4 \",\" target 4 \"\n\"source 5\",\"target 5,target 6\"\n\"source 5\",\"target 5,\"\"target 6\"\",target 7\"\nline without delimiter\n   \n";
        List<ConceptEntry> list = this.getConcepts(snippet, null, this.locEN, this.locFR);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)6L, (long)list.size());
        ConceptEntry cent = list.get(0);
        Assert.assertEquals((Object)"source 1", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 1", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(1);
        Assert.assertEquals((Object)"source 2", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 2", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(2);
        Assert.assertEquals((Object)"source 3", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 3", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(3);
        Assert.assertEquals((Object)" source 4 ", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)" target 4 ", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(4);
        Assert.assertEquals((Object)"source 5", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 5,target 6", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
        cent = list.get(5);
        Assert.assertEquals((Object)"source 5", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 5,\"target 6\",target 7", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidCSV() {
        String snippet = "source 1,target 1\n,target 2\ntarget1,\n,\n  source 2  ,  target 2  \n\"source 3\",\"target 3\"\n\" source 4 \",\" target 4 \"\n\"source 5\",\"target 5,target 6\"\n\"source 5\",\"target 5,\"\"target 6\"\",target 7\"\nsou\"rce 6,target 6\nline without delimiter\n   \n";
        List<ConceptEntry> list = this.getConcepts(snippet, null, this.locEN, this.locFR);
        Assert.assertNotNull(list);
        Assert.assertEquals((long)6L, (long)list.size());
        ConceptEntry cent = list.get(6);
        Assert.assertEquals((Object)"sou\"rce 6", (Object)cent.getEntries(this.locEN).getTerm(0).getText());
        Assert.assertEquals((Object)"target 6", (Object)cent.getEntries(this.locFR).getTerm(0).getText());
    }

    @Test
    public void testFromFiles() {
        File file = this.location.in("/test01.csv").asFile();
        List<ConceptEntry> list = this.getConcepts(null, file, this.locEN, this.locFR);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"target 3", (Object)list.get(2).getEntries(this.locFR).getTerm(0).getText());
    }

    List<ConceptEntry> getConcepts(String snippet, File file, LocaleId srcLoc, LocaleId trgLoc) {
        try {
            ArrayList<ConceptEntry> list = new ArrayList<ConceptEntry>();
            CSVReader csv = new CSVReader(srcLoc, trgLoc);
            if (file == null) {
                ByteArrayInputStream is = new ByteArrayInputStream(snippet.getBytes("UTF-8"));
                csv.open((InputStream)is);
            } else {
                csv.open(file);
            }
            while (csv.hasNext()) {
                list.add(csv.next());
            }
            csv.close();
            return list;
        }
        catch (Throwable e) {
            throw new OkapiException(e.getMessage());
        }
    }
}

