/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.WhitespaceStrategy;
import net.sf.okapi.proto.AltTranslation;
import net.sf.okapi.proto.Code;
import net.sf.okapi.proto.EndDocument;
import net.sf.okapi.proto.EndGroup;
import net.sf.okapi.proto.EndSubDocument;
import net.sf.okapi.proto.EndSubfilter;
import net.sf.okapi.proto.Event;
import net.sf.okapi.proto.Events;
import net.sf.okapi.proto.GenericAnnotation;
import net.sf.okapi.proto.GenericAnnotations;
import net.sf.okapi.proto.INameable;
import net.sf.okapi.proto.IReferenceable;
import net.sf.okapi.proto.IResource;
import net.sf.okapi.proto.Note;
import net.sf.okapi.proto.PrimitiveValue;
import net.sf.okapi.proto.Property;
import net.sf.okapi.proto.StartDocument;
import net.sf.okapi.proto.StartGroup;
import net.sf.okapi.proto.StartSubDocument;
import net.sf.okapi.proto.StartSubfilter;
import net.sf.okapi.proto.TextContainer;
import net.sf.okapi.proto.TextFragment;
import net.sf.okapi.proto.TextPart;
import net.sf.okapi.proto.TextUnit;

public class Okapi2Proto {
    static IResource toIResource(net.sf.okapi.common.IResource value) {
        IResource.Builder builder = IResource.newBuilder();
        if (value.getId() != null) {
            builder.setId(value.getId());
        }
        for (String propName : value.getPropertyNames()) {
            builder.addProperties(Okapi2Proto.toProperty(value.getProperty(propName)));
        }
        net.sf.okapi.common.annotation.GenericAnnotations anns = (net.sf.okapi.common.annotation.GenericAnnotations)value.getAnnotation(net.sf.okapi.common.annotation.GenericAnnotations.class);
        if (anns != null) {
            builder.setGenericAnnotations(Okapi2Proto.toGenericAnnotations(anns));
        }
        return builder.build();
    }

    private static GenericAnnotations toGenericAnnotations(net.sf.okapi.common.annotation.GenericAnnotations anns) {
        GenericAnnotations.Builder builder = GenericAnnotations.newBuilder();
        builder.setEncodedAsString(anns.toString());
        for (GenericAnnotation ann : anns) {
            builder.addGenericAnnotations(Okapi2Proto.toGenericAnnotation(ann));
        }
        return builder.build();
    }

    private static net.sf.okapi.proto.GenericAnnotation toGenericAnnotation(GenericAnnotation ann) {
        GenericAnnotation.Builder builder = net.sf.okapi.proto.GenericAnnotation.newBuilder();
        builder.setType(ann.getType());
        for (String n : ann.getNames()) {
            builder.putFields(n, Okapi2Proto.toPrimitiveValue(ann.getValue(n)));
        }
        return builder.build();
    }

    private static PrimitiveValue toPrimitiveValue(Object value) {
        PrimitiveValue.Builder builder = PrimitiveValue.newBuilder();
        assert (value != null);
        if (value instanceof String) {
            builder.setStringValue((String)value);
        } else if (value instanceof Integer) {
            builder.setIntValue((Integer)value);
        } else if (value instanceof Boolean) {
            builder.setBoolValue((Boolean)value);
        } else if (value instanceof Double) {
            builder.setDoubleValue((Double)value);
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
        }
        return builder.build();
    }

    static INameable toINameable(net.sf.okapi.common.resource.INameable value) {
        INameable.Builder builder = INameable.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)value));
        builder.setIsTranslatable(value.isTranslatable()).setPreserveWhitespaces(value.preserveWhitespaces());
        if (value.getType() != null) {
            builder.setType(value.getType());
        }
        if (value.getMimeType() != null) {
            builder.setMimeType(value.getMimeType());
        }
        if (value.getName() != null) {
            builder.setName(value.getName());
        }
        return builder.build();
    }

    static IReferenceable toIReferenceable(net.sf.okapi.common.resource.IReferenceable value) {
        IReferenceable.Builder builder = IReferenceable.newBuilder().setRefCount(value.getReferenceCount());
        return builder.build();
    }

    static TextFragment.TagType toTagType(TextFragment.TagType tt) {
        switch (tt) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case PLACEHOLDER: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        return TextFragment.TagType.UNRECOGNIZED;
    }

    static Code toCode(net.sf.okapi.common.resource.Code code, int position, boolean isolated) {
        Code.Builder builder = Code.newBuilder().setTagType(Okapi2Proto.toTagType(code.getTagType())).setId(code.getId()).setCodeType(code.getType()).setData(code.getData()).setFlag(code.getFlag()).setPosition(position).setIsolated(isolated).setAdded(code.isAdded());
        if (code.hasOuterData()) {
            builder.setOuterData(code.getOuterData());
        }
        if (code.getTagType() == TextFragment.TagType.PLACEHOLDER) {
            builder.setIsolated(false);
        }
        if (null != code.getDisplayText()) {
            builder.setDisplayText(code.getDisplayText());
        }
        if (null != code.getOriginalId()) {
            builder.setOriginalId(code.getOriginalId());
        }
        if (null != code.getMergedData() && !code.getMergedData().isEmpty()) {
            builder.setMergedData(code.getMergedData());
        }
        if (code.hasAnnotation()) {
            for (String ann : code.getAnnotationsTypes()) {
                if ("PROPERTIES".equals(ann)) continue;
                builder.putInlineAnnotations(ann, code.getAnnotation(ann).toString());
            }
        }
        for (String propName : code.getPropertyNames()) {
            builder.addProperties(Okapi2Proto.toProperty(code.getProperty(propName)));
        }
        return builder.build();
    }

    static TextFragment toTextFragment(net.sf.okapi.common.resource.TextFragment tf) {
        tf.balanceMarkers();
        TextFragment.Builder builder = TextFragment.newBuilder().setText(tf.getText());
        if (tf.hasCode()) {
            tf.balanceMarkers();
            List codes = tf.getCodes();
            int codeCount = 0;
            block3: for (int i = 0; i < tf.length(); ++i) {
                switch (tf.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        net.sf.okapi.common.resource.Code code = (net.sf.okapi.common.resource.Code)codes.get(net.sf.okapi.common.resource.TextFragment.toIndex((char)tf.charAt(++i)));
                        int newPos = i - codeCount * 2;
                        builder.addCodes(Okapi2Proto.toCode(code, newPos - 1, tf.charAt(i - 1) == '\ue103'));
                        ++codeCount;
                        continue block3;
                    }
                }
            }
        }
        return builder.build();
    }

    static Property toProperty(net.sf.okapi.common.resource.Property prop) {
        Property.Builder builder = Property.newBuilder().setName(prop.getName()).setValue(prop.getValue() == null ? "" : prop.getValue()).addAllTypes(Okapi2Proto.toPropertyTypes(prop.getTypes())).setReadOnly(prop.isReadOnly());
        return builder.build();
    }

    static List<Property.PropertyType> toPropertyTypes(EnumSet<Property.Type> types) {
        ArrayList<Property.PropertyType> result = new ArrayList<Property.PropertyType>();
        for (Property.Type type : types) {
            result.add(Property.PropertyType.valueOf(type.name()));
        }
        return result;
    }

    static TextContainer toTextContainer(net.sf.okapi.common.resource.TextContainer tc, LocaleId locale) {
        AltTranslationsAnnotation ats;
        TextContainer.Builder builder = TextContainer.newBuilder().setSegApplied(tc.hasBeenSegmented()).setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)tc)).setLocale(locale == null ? "und" : locale.toBCP47());
        for (Object part : tc.getParts()) {
            builder.addParts(Okapi2Proto.toTextPart((TextPart)part));
        }
        NoteAnnotation na = (NoteAnnotation)tc.getAnnotation(NoteAnnotation.class);
        if (na != null) {
            for (net.sf.okapi.common.annotation.Note note : na) {
                builder.addNotes(Okapi2Proto.toNote(note));
            }
        }
        if ((ats = (AltTranslationsAnnotation)tc.getAnnotation(AltTranslationsAnnotation.class)) != null) {
            for (net.sf.okapi.common.annotation.AltTranslation altTranslation : ats) {
                builder.addAltTrans(Okapi2Proto.toAltTrans(altTranslation));
            }
        }
        return builder.build();
    }

    static net.sf.okapi.proto.TextPart toTextPart(TextPart part) {
        TextPart.Builder builder = net.sf.okapi.proto.TextPart.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)part)).setSegment(part.isSegment()).setWhitespaceStrategy(Okapi2Proto.toWhitespaceStrategy(part.getWhitespaceStrategy())).setText(Okapi2Proto.toTextFragment(part.getContent()));
        if (part.getOriginalId() != null) {
            builder.setOriginalId(part.getOriginalId());
        }
        return builder.build();
    }

    static TextPart.WhitespaceStrategy toWhitespaceStrategy(WhitespaceStrategy whitespaceStrategy) {
        switch (whitespaceStrategy) {
            case INHERIT: {
                return TextPart.WhitespaceStrategy.INHERIT;
            }
            case NORMALIZE: {
                return TextPart.WhitespaceStrategy.NORMALIZE;
            }
            case PRESERVE: {
                return TextPart.WhitespaceStrategy.PRESERVE;
            }
        }
        return TextPart.WhitespaceStrategy.UNRECOGNIZED;
    }

    static Note toNote(net.sf.okapi.common.annotation.Note note) {
        Note.Builder builder = Note.newBuilder().setNote(note.getNoteText()).setAnnotates(Okapi2Proto.toAnnotates(note.getAnnotates() == null ? Note.Annotates.GENERAL : note.getAnnotates())).setPriority(Okapi2Proto.toPriority(note.getPriority() == null ? Note.Priority.ONE : note.getPriority())).setFrom(note.getFrom() == null ? "" : note.getFrom()).setXmlLang(note.getXmLang() == null ? "" : note.getXmLang());
        return builder.build();
    }

    static AltTranslation.MatchType toMatchType(MatchType matchType) {
        switch (matchType) {
            case ACCEPTED: {
                return AltTranslation.MatchType.ACCEPTED;
            }
            case EXACT_UNIQUE_ID: {
                return AltTranslation.MatchType.EXACT_UNIQUE_ID;
            }
            case EXACT_LOCAL_CONTEXT: {
                return AltTranslation.MatchType.EXACT_LOCAL_CONTEXT;
            }
            case EXACT: {
                return AltTranslation.MatchType.EXACT;
            }
            case EXACT_TEXT_ONLY: {
                return AltTranslation.MatchType.EXACT_TEXT_ONLY;
            }
            case FUZZY: {
                return AltTranslation.MatchType.FUZZY;
            }
        }
        return AltTranslation.MatchType.UKNOWN;
    }

    static AltTranslation toAltTrans(net.sf.okapi.common.annotation.AltTranslation altTrans) {
        AltTranslation.Builder builder = AltTranslation.newBuilder().setTextUnit(Okapi2Proto.toTextUnit(altTrans.getTextUnit(), altTrans.getSourceLocale())).setSourceLocale(altTrans.getSourceLocale().toBCP47()).setTargetLocale(altTrans.getTargetLocale().toBCP47()).setType(Okapi2Proto.toMatchType(altTrans.getType())).setCombinedScore(altTrans.getCombinedScore()).setOrigin(altTrans.getOrigin());
        if (altTrans.getEngine() != null) {
            builder.setEngine(altTrans.getEngine());
        }
        builder.setFromOriginal(altTrans.getFromOriginal());
        builder.setFuzzyScore(altTrans.getFuzzyScore());
        builder.setQualityScore(altTrans.getQualityScore());
        builder.setAltTransType(altTrans.getALttransType());
        return builder.build();
    }

    static Note.Annotates toAnnotates(Note.Annotates annotates) {
        switch (annotates) {
            case SOURCE: {
                return Note.Annotates.SOURCE;
            }
            case TARGET: {
                return Note.Annotates.TARGET;
            }
        }
        return Note.Annotates.GENERAL;
    }

    static Note.Priority toPriority(Note.Priority priority) {
        switch (priority) {
            case ONE: {
                return Note.Priority.ONE;
            }
            case TWO: {
                return Note.Priority.TWO;
            }
            case THREE: {
                return Note.Priority.THREE;
            }
            case FOUR: {
                return Note.Priority.FOUR;
            }
            case FIVE: {
                return Note.Priority.FIVE;
            }
            case SIX: {
                return Note.Priority.SIX;
            }
            case SEVEN: {
                return Note.Priority.SEVEN;
            }
            case EIGHT: {
                return Note.Priority.EIGHT;
            }
            case NINE: {
                return Note.Priority.NINE;
            }
        }
        return Note.Priority.TEN;
    }

    static TextUnit toTextUnit(ITextUnit tu, LocaleId sourceLocale) {
        TextUnit.Builder builder = TextUnit.newBuilder().setSource(Okapi2Proto.toTextContainer(tu.getSource(), sourceLocale)).setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)tu)).setReferenceable(Okapi2Proto.toIReferenceable((net.sf.okapi.common.resource.IReferenceable)tu));
        HashMap<String, TextContainer> targets = new HashMap<String, TextContainer>();
        for (LocaleId locale : tu.getTargetLocales()) {
            targets.put(locale.toBCP47(), Okapi2Proto.toTextContainer(tu.getTarget(locale), locale));
        }
        builder.putAllTargets(targets);
        NoteAnnotation na = (NoteAnnotation)tu.getAnnotation(NoteAnnotation.class);
        if (na != null) {
            for (net.sf.okapi.common.annotation.Note note : na) {
                builder.addNotes(Okapi2Proto.toNote(note));
            }
        }
        return builder.build();
    }

    static StartDocument toStartDocument(net.sf.okapi.common.resource.StartDocument sdoc) {
        StartDocument.Builder builder = StartDocument.newBuilder().setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)sdoc)).setHasUtf8Bom(sdoc.hasUTF8BOM()).setMultilingual(sdoc.isMultilingual());
        if (null != sdoc.getEncoding()) {
            builder.setEncoding(sdoc.getEncoding());
        }
        if (null != sdoc.getLineBreak()) {
            builder.setLineBreak(sdoc.getLineBreak());
        }
        if (null != sdoc.getLocale()) {
            builder.setLocale(sdoc.getLocale().toBCP47());
        }
        if (null != sdoc.getFilterParameters()) {
            builder.setParameters(sdoc.getFilterParameters().toString());
        }
        return builder.build();
    }

    static EndDocument toEndDocument(Ending value) {
        EndDocument.Builder builder = EndDocument.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)value));
        return builder.build();
    }

    static EndGroup toEndGroup(Ending value) {
        EndGroup.Builder builder = EndGroup.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)value));
        return builder.build();
    }

    static StartGroup toStartGroup(net.sf.okapi.common.resource.StartGroup value) {
        StartGroup.Builder builder = StartGroup.newBuilder().setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)value)).setReferenceable(Okapi2Proto.toIReferenceable((net.sf.okapi.common.resource.IReferenceable)value));
        String parentId = value.getParentId();
        if (null != parentId) {
            builder.setParentId(parentId);
        }
        return builder.build();
    }

    static StartSubfilter toStartSubfilter(net.sf.okapi.common.resource.StartSubfilter value) {
        StartSubfilter.Builder builder = StartSubfilter.newBuilder().setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)value)).setStartDoc(Okapi2Proto.toStartDocument(value.getStartDoc()));
        return builder.build();
    }

    static EndSubfilter toEndSubfilter(net.sf.okapi.common.resource.EndSubfilter value) {
        EndSubfilter.Builder builder = EndSubfilter.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)value));
        return builder.build();
    }

    static EndSubDocument toEndSubDocument(Ending value) {
        EndSubDocument.Builder builder = EndSubDocument.newBuilder().setResource(Okapi2Proto.toIResource((net.sf.okapi.common.IResource)value));
        return builder.build();
    }

    static StartSubDocument toStartSubDocument(net.sf.okapi.common.resource.StartSubDocument value) {
        String filterIdId;
        StartSubDocument.Builder builder = StartSubDocument.newBuilder().setNameable(Okapi2Proto.toINameable((net.sf.okapi.common.resource.INameable)value));
        String parentId = value.getParentId();
        if (null != parentId) {
            builder.setParentId(parentId);
        }
        if (null != (filterIdId = value.getFilterId())) {
            builder.setFilterId(filterIdId);
        }
        return builder.build();
    }

    public static Event toEvent(net.sf.okapi.common.Event event, LocaleId sourceLocale) {
        Event.Builder builder = Event.newBuilder();
        if (event.isStartDocument()) {
            builder.setStartDocument(Okapi2Proto.toStartDocument(event.getStartDocument()));
        } else if (event.isEndDocument()) {
            builder.setEndDocument(Okapi2Proto.toEndDocument(event.getEnding()));
        } else if (event.isTextUnit()) {
            builder.setTextUnit(Okapi2Proto.toTextUnit(event.getTextUnit(), sourceLocale));
        } else if (event.isStartGroup()) {
            builder.setStartGroup(Okapi2Proto.toStartGroup(event.getStartGroup()));
        } else if (event.isEndGroup()) {
            builder.setEndGroup(Okapi2Proto.toEndGroup(event.getEnding()));
        } else if (event.isStartSubfilter()) {
            builder.setStartSubfilter(Okapi2Proto.toStartSubfilter(event.getStartSubfilter()));
        } else if (event.isEndSubfilter()) {
            builder.setEndSubfilter(Okapi2Proto.toEndSubfilter(event.getEndSubfilter()));
        } else if (event.isStartSubDocument()) {
            builder.setStartSubDocument(Okapi2Proto.toStartSubDocument(event.getStartSubDocument()));
        } else if (event.isEndSubDocument()) {
            builder.setEndSubDocument(Okapi2Proto.toEndSubDocument(event.getEnding()));
        }
        return builder.build();
    }

    public static Events toEvents(List<net.sf.okapi.common.Event> events, LocaleId sourceLocale) {
        Events.Builder builder = Events.newBuilder();
        for (net.sf.okapi.common.Event e : events) {
            builder.addEvents(Okapi2Proto.toEvent(e, sourceLocale));
        }
        return builder.build();
    }
}

