/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.writer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.DummyFilter;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.lib.serialization.writer.ProtoBufferWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoJsonWriterTest {
    private static final String SIMPLE_OUTPUT = "{\"startDocument\":{\"nameable\":{\"resource\":{\"id\":\"sd1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"text/xml\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"lineBreak\":\"\",\"locale\":\"en\",\"encoding\":\"\",\"multilingual\":true,\"hasUtf8Bom\":false,\"parameters\":\"\"}}\n{\"textUnit\":{\"nameable\":{\"resource\":{\"id\":\"tu1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"referenceable\":{\"refCount\":0},\"parentId\":\"\",\"source\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"en\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"Source text\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":false,\"altTrans\":[],\"notes\":[]},\"targets\":{\"fr\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"fr\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"Target text\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":false,\"altTrans\":[],\"notes\":[]}},\"notes\":[]}}\n{\"textUnit\":{\"nameable\":{\"resource\":{\"id\":\"tu2\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"referenceable\":{\"refCount\":0},\"parentId\":\"\",\"source\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"en\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"Source text 2\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":false,\"altTrans\":[],\"notes\":[]},\"targets\":{},\"notes\":[]}}\n{\"endDocument\":{\"resource\":{\"id\":\"ed1\",\"properties\":[]}}}\n";
    private static final String SEGMENTED_OUTPUT = "{\"startDocument\":{\"nameable\":{\"resource\":{\"id\":\"sd1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"text/xml\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"lineBreak\":\"\",\"locale\":\"en\",\"encoding\":\"\",\"multilingual\":true,\"hasUtf8Bom\":false,\"parameters\":\"\"}}\n{\"textUnit\":{\"nameable\":{\"resource\":{\"id\":\"tu1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"referenceable\":{\"refCount\":0},\"parentId\":\"\",\"source\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"en\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"First segment for SRC.\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true},{\"resource\":{\"id\":\"1\",\"properties\":[]},\"text\":{\"text\":\" \",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":false},{\"resource\":{\"id\":\"2\",\"properties\":[]},\"text\":{\"text\":\"Second segment for SRC\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":true,\"altTrans\":[],\"notes\":[]},\"targets\":{\"fr\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"fr\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"First segment for TRG.\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true},{\"resource\":{\"id\":\"1\",\"properties\":[]},\"text\":{\"text\":\" \",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":false},{\"resource\":{\"id\":\"2\",\"properties\":[]},\"text\":{\"text\":\"Second segment for TRG\",\"codes\":[],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":true,\"altTrans\":[],\"notes\":[]}},\"notes\":[]}}\n{\"endDocument\":{\"resource\":{\"id\":\"ed1\",\"properties\":[]}}}\n";
    private static final String CODES_OUTPUT = "{\"startDocument\":{\"nameable\":{\"resource\":{\"id\":\"sd1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"text\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"lineBreak\":\"\",\"locale\":\"en\",\"encoding\":\"\",\"multilingual\":true,\"hasUtf8Bom\":false,\"parameters\":\"\"}}\n{\"textUnit\":{\"nameable\":{\"resource\":{\"id\":\"id1\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"referenceable\":{\"refCount\":0},\"parentId\":\"\",\"source\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"en\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"Source code \",\"codes\":[{\"id\":1,\"tagType\":\"PLACEHOLDER\",\"codeType\":\"z\",\"data\":\"@#$0\",\"flag\":0,\"position\":12,\"isolated\":false,\"added\":false,\"properties\":[],\"inlineAnnotations\":{}}],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":false,\"altTrans\":[],\"notes\":[]},\"targets\":{\"fr\":{\"nameable\":{\"resource\":{\"id\":\"\",\"properties\":[]},\"name\":\"\",\"type\":\"\",\"mimeType\":\"\",\"isTranslatable\":true,\"preserveWhitespaces\":false},\"locale\":\"fr\",\"parts\":[{\"resource\":{\"id\":\"0\",\"properties\":[]},\"text\":{\"text\":\"Target code \",\"codes\":[{\"id\":1,\"tagType\":\"PLACEHOLDER\",\"codeType\":\"z\",\"data\":\"@#$0\",\"flag\":0,\"position\":12,\"isolated\":false,\"added\":false,\"properties\":[],\"inlineAnnotations\":{}}],\"balanced\":false},\"whitespaceStrategy\":\"INHERIT\",\"segment\":true}],\"segApplied\":false,\"altTrans\":[],\"notes\":[]}},\"notes\":[]}}\n{\"endDocument\":{\"resource\":{\"id\":\"ed1\",\"properties\":[]}}}\n";
    private DummyFilter filter;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.filter = new DummyFilter();
    }

    @Test
    public void testSimpleOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"##def##", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)SIMPLE_OUTPUT, (Object)result);
    }

    @Test
    public void testSegmentedOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"##seg##", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)SEGMENTED_OUTPUT, (Object)result);
    }

    @Test
    public void testCodesOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"Source code @#$0\nTarget code @#$0", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)CODES_OUTPUT, (Object)result);
    }

    private String rewrite(ArrayList<Event> list, LocaleId trgLang) {
        ProtoBufferWriter writer = new ProtoBufferWriter();
        writer.setOptions(trgLang, null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writer.setOutput((OutputStream)output);
        for (Event event : list) {
            writer.handleEvent(event);
        }
        writer.close();
        return output.toString();
    }
}

