/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.step;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.serialization.writer.ProtoBufferWriter;
import net.sf.okapi.steps.common.FilterEventsWriterStep;

public class MergerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Event> getTextUnitEvents(IFilter filter, RawDocument rd) {
        ArrayList<Event> list = new ArrayList<Event>();
        try {
            filter.open(rd);
            while (filter.hasNext()) {
                Event e = filter.next();
                if (!e.isTextUnit()) continue;
                list.add(e);
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
        }
        return list;
    }

    public static void writeJson(List<Event> events, String root, String path) {
        ProtoBufferWriter writer = new ProtoBufferWriter();
        writer.setOptions(LocaleId.SPANISH, "UTF-8");
        writer.setOutput(path);
        FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
        fewStep.setDocumentRoots(root);
        fewStep.setFilterWriter((IFilterWriter)writer);
        fewStep.setOutputURI(Util.toURI((String)path));
        fewStep.setOutputEncoding("UTF-8");
        fewStep.setLastOutputStep(true);
        fewStep.setTargetLocale(LocaleId.ENGLISH);
        for (Event event : events) {
            fewStep.handleEvent(event);
        }
        writer.close();
        fewStep.destroy();
    }
}

