/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.writer;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.serialization.textunitflat.TextUnitFlat2Proto;
import net.sf.okapi.lib.serialization.writer.Parameters;
import net.sf.okapi.proto.textunitflat.TextUnits;

public class ProtoBufferTextUnitFlatWriter
implements IFilterWriter {
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean canceled;
    private Parameters params = new Parameters();
    private OutputStreamWriter outputWriter;
    private final List<ITextUnit> textUnits = new LinkedList<ITextUnit>();

    public String getName() {
        return this.getClass().getName();
    }

    public void setOptions(LocaleId targetLocale, String defaultEncoding) {
        this.targetLocale = targetLocale;
    }

    public void setOutput(String path) {
        this.outputPath = path;
    }

    public void setOutput(OutputStream output) {
        this.outputPath = null;
        this.outputStream = output;
    }

    public Event handleEvent(Event event) {
        if (this.canceled) {
            return new Event(EventType.CANCELED);
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.saveTextUnits();
                break;
            }
            default: {
                event = Event.createNoopEvent();
            }
        }
        return event;
    }

    private void processTextUnit(Event event) {
        if (this.params.isCopySource() && (!event.getTextUnit().hasTarget(this.targetLocale) || event.getTextUnit().getTarget(this.targetLocale).isEmpty())) {
            TextContainer tc = event.getTextUnit().getSource().clone();
            event.getTextUnit().setTarget(this.targetLocale, tc);
        }
        this.textUnits.add(event.getTextUnit());
    }

    private void saveTextUnits() {
        switch (this.params.getOutput()) {
            case TEXT: {
                this.saveToTextFile(this.outputStream, TextUnitFlat2Proto.toTextUnits(this.textUnits, this.sourceLocale));
                break;
            }
            case JSON: {
                this.saveToJsonFile(this.outputStream, TextUnitFlat2Proto.toTextUnits(this.textUnits, this.sourceLocale));
                break;
            }
            case BINARY: {
                this.saveToBinaryFile(this.outputStream, TextUnitFlat2Proto.toTextUnits(this.textUnits, this.sourceLocale));
            }
        }
    }

    private void saveToTextFile(OutputStream outStream, TextUnits proto) {
        try {
            String text = TextFormat.printer().escapingNonAscii(false).printToString((MessageOrBuilder)proto);
            outStream.write(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
    }

    private void saveToJsonFile(OutputStream outStream, TextUnits proto) {
        try {
            String jsonText = JsonFormat.printer().print((MessageOrBuilder)proto);
            outStream.write(jsonText.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
    }

    private void saveToBinaryFile(OutputStream outStream, TextUnits proto) {
        try {
            proto.writeTo(outStream);
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
    }

    private void processStartDocument(Event event) {
        if (this.outputStream == null) {
            try {
                this.outputStream = new FileOutputStream(this.outputPath);
            }
            catch (FileNotFoundException e) {
                throw new OkapiIOException("Error serializing TextUnit", (Throwable)e);
            }
        }
        this.sourceLocale = event.getStartDocument().getLocale();
    }

    public void close() {
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
                this.outputWriter = null;
                this.outputStream = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing JSON writer", (Throwable)e);
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing protobuf stream", (Throwable)e);
            }
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    public void cancel() {
        this.close();
        this.canceled = true;
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

