/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.filter;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.serialization.textunitflat.Proto2TextUnitFlat;
import net.sf.okapi.proto.textunitflat.TextUnit;
import net.sf.okapi.proto.textunitflat.TextUnits;

public class TextUnitFlatFilter
extends AbstractFilter {
    private static final String MIMETYPE = "text/x-flat-text-unit";
    private RawDocument input;
    private EventBuilder eventBuilder;
    private boolean binary = false;

    public TextUnitFlatFilter() {
        this.setMimeType(MIMETYPE);
        this.setMultilingual(false);
        this.setName("okf_textunitflat");
        this.setDisplayName("Flat TextUnit Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), MIMETYPE, ((Object)((Object)this)).getClass().getName(), "Protobuffer Flat TextUnit", "Configuration for Flat TextUnit files of various types", null, ".json;"));
    }

    public void open(RawDocument input) {
        this.open(input, false);
    }

    public void open(RawDocument input, boolean generateSkeleton) {
        TextUnits tus;
        this.input = input;
        this.input.setEncoding(StandardCharsets.UTF_8);
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder(this.getParentId(), (IFilter)this);
        } else {
            this.eventBuilder.reset(this.getParentId(), (IFilter)this);
        }
        this.eventBuilder.setMimeType(MIMETYPE);
        this.eventBuilder.setPreserveWhitespace(true);
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        try {
            tus = this.loadFromText(input.getStream());
        }
        catch (OkapiBadFilterInputException e1) {
            try {
                tus = this.loadFromBinary(input.getStream());
                this.binary = true;
            }
            catch (OkapiBadFilterInputException e2) {
                try {
                    tus = this.loadFromJson(input.getStream());
                }
                catch (OkapiBadFilterInputException e3) {
                    throw new OkapiBadFilterInputException("Error loading TextUnits. Bad input format.");
                }
            }
        }
        for (TextUnit tu : tus.getTextUnitsList()) {
            this.eventBuilder.addFilterEvent(new Event(EventType.TEXT_UNIT, (IResource)Proto2TextUnitFlat.toTextUnit(tu)));
        }
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    public void setParameters(IParameters params) {
    }

    public IParameters getParameters() {
        return null;
    }

    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    public Event next() {
        return this.eventBuilder.next();
    }

    private TextUnits loadFromBinary(InputStream inputStream) {
        try {
            return TextUnits.parseFrom(inputStream);
        }
        catch (IOException e) {
            throw new OkapiBadFilterInputException("Error parsing or converting Protobuf TextUnits", (Throwable)e);
        }
    }

    private TextUnits loadFromText(InputStream inputStream) {
        TextUnits textUnits;
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try {
            TextUnits.Builder builder = TextUnits.newBuilder();
            TextFormat.Parser.newBuilder().build().merge((Readable)reader, (Message.Builder)builder);
            textUnits = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OkapiBadFilterInputException("Error parsing or converting Protobuf Text TextUnits", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return textUnits;
    }

    private TextUnits loadFromJson(InputStream inputStream) {
        TextUnits textUnits;
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try {
            TextUnits.Builder builder = TextUnits.newBuilder();
            JsonFormat.parser().merge((Reader)reader, (Message.Builder)builder);
            textUnits = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OkapiBadFilterInputException("Error parsing or converting JSON TextUnits", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return textUnits;
    }

    protected boolean isUtf8Encoding() {
        return !this.binary;
    }

    protected boolean isUtf8Bom() {
        return false;
    }

    public void close() {
        if (this.input != null) {
            this.input.close();
        }
    }
}

