/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.writer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.DummyFilter;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.lib.serialization.writer.ProtoBufferTextUnitFlatWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoBufferTextUnitFlatWriterTest {
    private static final String SIMPLE_OUTPUT = "textUnits {  id: \"tu1\"  translatable: true  source {    parts {      id: \"0\"      text {        text: \"Source text\"      }      segment: true    }    locale: \"en\"  }  targets {    key: \"fr\"    value {      parts {        id: \"0\"        text {          text: \"Target text\"        }        segment: true      }      locale: \"fr\"    }  }}textUnits {  id: \"tu2\"  translatable: true  source {    parts {      id: \"0\"      text {        text: \"Source text 2\"      }      segment: true    }    locale: \"en\"  }}";
    private static final String SEGMENTED_OUTPUT = "textUnits {  id: \"tu1\"  translatable: true  source {    parts {      id: \"0\"      text {        text: \"First segment for SRC.\"      }      segment: true    }    parts {      text {        text: \" \"      }    }    parts {      id: \"1\"      text {        text: \"Second segment for SRC\"      }      segment: true    }    segApplied: true    locale: \"en\"  }  targets {    key: \"fr\"    value {      parts {        id: \"0\"        text {          text: \"First segment for TRG.\"        }        segment: true      }      parts {        text {          text: \" \"        }      }      parts {        id: \"1\"        text {          text: \"Second segment for TRG\"        }        segment: true      }      segApplied: true      locale: \"fr\"    }  }}";
    private static final String CODES_OUTPUT = "textUnits {  id: \"id1\"  translatable: true  source {    parts {      id: \"0\"      text {        text: \"Source code \"        codes {          tagType: PLACEHOLDER          id: 1          codeType: \"z\"          data: \"@#$0\"          outerData: \"@#$0\"          position: 12          isolated: true        }      }      segment: true    }    locale: \"en\"  }  targets {    key: \"fr\"    value {      parts {        id: \"0\"        text {          text: \"Target code \"          codes {            tagType: PLACEHOLDER            id: 1            codeType: \"z\"            data: \"@#$0\"            outerData: \"@#$0\"            position: 12            isolated: true          }        }        segment: true      }      locale: \"fr\"    }  }}";
    private DummyFilter filter;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.filter = new DummyFilter();
    }

    @Test
    public void testSimpleOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"##def##", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)SIMPLE_OUTPUT, (Object)result.replaceAll("[\\r\\n\u001e]", ""));
    }

    @Test
    public void testSegmentedOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"##seg##", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)SEGMENTED_OUTPUT, (Object)result.replaceAll("[\\r\\n\u001e]", ""));
    }

    @Test
    public void testCodesOutput() {
        String result = this.rewrite(FilterTestDriver.getEvents((IFilter)this.filter, (String)"Source code @#$0\nTarget code @#$0", (LocaleId)this.locEN, (LocaleId)this.locFR), this.locFR);
        Assert.assertEquals((Object)CODES_OUTPUT, (Object)result.replaceAll("[\\r\\n\u001e]", ""));
    }

    private String rewrite(ArrayList<Event> list, LocaleId trgLang) {
        ProtoBufferTextUnitFlatWriter writer = new ProtoBufferTextUnitFlatWriter();
        writer.setOptions(trgLang, null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writer.setOutput((OutputStream)output);
        for (Event event : list) {
            writer.handleEvent(event);
        }
        writer.close();
        return output.toString();
    }
}

