/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.step;

import java.util.ArrayList;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.serialization.step.MergerUtil;
import net.sf.okapi.lib.serialization.step.OriginalDocumentTextUnitFlatMergerStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OriginalDocumentTextUnitFlatJsonMergerStepTest {
    private HtmlFilter htmlFilter;
    private XLIFFFilter xliffFilter;
    private FileLocation fileLocation;
    private OriginalDocumentTextUnitFlatMergerStep merger;
    private RawDocumentWriterStep writer;

    @Before
    public void setUp() {
        this.htmlFilter = new HtmlFilter();
        this.xliffFilter = new XLIFFFilter();
        this.merger = new OriginalDocumentTextUnitFlatMergerStep();
        this.writer = new RawDocumentWriterStep();
        this.fileLocation = FileLocation.fromClass(this.getClass());
    }

    @After
    public void tearDown() {
        this.htmlFilter.close();
        this.merger.destroy();
        this.writer.destroy();
    }

    @Test
    public void simpleMerge() {
        String file = "/simple.html";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.htmlFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH);
        rd.setFilterConfigId("okf_html");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.FRENCH);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.ENGLISH)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.htmlFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.htmlFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void simpleXliff() {
        String file = "/simple.xlf";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.FRENCH);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void simpleSegmentedXliff() {
        String file = "/segmented.xlf";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.GERMAN);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void segmentedEmptyTarget() {
        String file = "/segmented_empty_targets.xlf";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.GERMAN);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void segmentedInterSegment() {
        String file = "/segmented_inter_segment.xlf";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.GERMAN);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void segmentedExtraTarget() {
        String file = "/segmented_diff_segments.xlf";
        String input = this.fileLocation.in(file).toString();
        String root = this.fileLocation.in("/").toString();
        String output = this.fileLocation.in(file + ".json").toString();
        String merged = this.fileLocation.in(file + ".merged").toString();
        MergerUtil.writeJson(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN), null), root, output);
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.GERMAN);
        this.merger.setTargetLocales(ts);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(Util.toURI((String)output), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)));
        this.writer.setOutputURI(Util.toURI((String)merged));
        this.writer.handleEvent(e);
        this.writer.destroy();
        RawDocument ord = new RawDocument(Util.toURI((String)input), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        RawDocument trd = new RawDocument(Util.toURI((String)merged), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }
}

