/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestJavaRegex {
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private SRXSegmenter segmenter;
    private SRXDocument doc;
    private ArrayList<Rule> rules;
    static boolean isJdk7Tested = false;
    static boolean isJdk7 = false;

    @Before
    public void startUp() {
        this.doc = new SRXDocument();
        this.segmenter = new SRXSegmenter();
        this.rules = new ArrayList();
    }

    @Test
    public void testMetachars() {
        this.testBreak("before\u0007After", "\\a", "A", "before\u0007", "After");
        this.testBreak("before\u0007After", "[\\a ]", "A", "before\u0007", "After");
        this.testBreak("before_After", "[\\a_]", "A", "before_", "After");
        this.testBreak("before After", "[\\a ]", "A", "before ", "After");
        this.testBreak("After", "\\AA", "f", "A", "fter");
        this.testBreak("before\nAfter", "\\Abef", "ore", "bef", "ore\nAfter");
        this.testBreak("before After", "\\b", "A", "before ", "After");
        this.testBreak("before After", "\\b", " ", "before", " After");
        this.testBreak("before\rAfter", "\\b", "\r", "before", "\rAfter");
        this.testBreak("before afAter", "\\B", "A", "before af", "Ater");
        this.testBreak("before after", "\\B", "o", "bef", "ore after");
        this.testBreak("befo\rreAfter", "\\B", "A", "befo\rre", "After");
        this.testBreak("before\u0001After", "\\cA", "A", "before\u0001", "After");
        this.testBreak("before\u0002After", "\\cB", "A", "before\u0002", "After");
        this.testBreak("before\u0003After", "\\cC", "A", "before\u0003", "After");
        this.testBreak("before\u0004After", "\\cD", "A", "before\u0004", "After");
        this.testBreak("before\u0005After", "\\cE", "A", "before\u0005", "After");
        this.testBreak("before\u0006After", "\\cF", "A", "before\u0006", "After");
        this.testBreak("before\u0007After", "\\cG", "A", "before\u0007", "After");
        this.testBreak("before\bAfter", "\\cH", "A", "before\b", "After");
        this.testBreak("before\tAfter", "\\cI", "A", "before\t", "After");
        this.testBreak("before\nAfter", "\\cJ", "A", "before\n", "After");
        this.testBreak("before\u000bAfter", "\\cK", "A", "before\u000b", "After");
        this.testBreak("before\fAfter", "\\cL", "A", "before\f", "After");
        this.testBreak("before\rAfter", "\\cM", "A", "before\r", "After");
        this.testBreak("before\u000eAfter", "\\cN", "A", "before\u000e", "After");
        this.testBreak("before\u000fAfter", "\\cO", "A", "before\u000f", "After");
        this.testBreak("before\u0010After", "\\cP", "A", "before\u0010", "After");
        this.testBreak("before\u0011After", "\\cQ", "A", "before\u0011", "After");
        this.testBreak("before\u0012After", "\\cR", "A", "before\u0012", "After");
        this.testBreak("before\u0013After", "\\cS", "A", "before\u0013", "After");
        this.testBreak("before\u0014After", "\\cT", "A", "before\u0014", "After");
        this.testBreak("before\u0015After", "\\cU", "A", "before\u0015", "After");
        this.testBreak("before\u0016After", "\\cV", "A", "before\u0016", "After");
        this.testBreak("before\u0017After", "\\cW", "A", "before\u0017", "After");
        this.testBreak("before\u0018After", "\\cX", "A", "before\u0018", "After");
        this.testBreak("before\u0019After", "\\cY", "A", "before\u0019", "After");
        this.testBreak("before\u001aAfter", "\\cZ", "A", "before\u001a", "After");
        this.testBreak("before\u001aAfter", "[\\cZ\\cA]", "A", "before\u001a", "After");
        this.testBreak("before\u0001After", "[\\cZ\\cA]", "A", "before\u0001", "After");
        this.testBreak("before001After", "\\d", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "\\d", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "[\\d]", "A", "before001", "After");
        this.testBreak("before\u0969After", "\\d", "A", "before\u0969", "After");
        this.testAssertionError("before\u4e20After", "\\d", "A", "before\u4e20", "After");
        this.testBreak("before001After", "[\\d]", "A", "before001", "After");
        this.testBreak("before001After", "[\\d\\r]", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "[\\d\\r]", "A", "before001", "After");
        this.testAssertionError("before\u4e20After", "[\\d\\r]", "A", "before\u4e20", "After");
        this.testBreak("before\rAfter", "[\\d\\r]", "A", "before\r", "After");
        this.testBreak("beforeAfter", "\\D", "A", "before", "After");
        this.testAssertionError("before\u0969After", "\\D", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\D]", "A", "before", "After");
        this.testAssertionError("before\u0969After", "[\\D]", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\D\\r]", "A", "before", "After");
        this.testAssertionError("before\u0969After", "[\\D\\r]", "A", "before", "After");
        this.testBreak("before\rAfter", "[\\D\\r]", "A", "before\r", "After");
        this.testBreak("before\u001bAfter", "\\e", "A", "before\u001b", "After");
        this.testBreak("before\u001bAfter", "[\\e\\r]", "A", "before\u001b", "After");
        this.testBreak("be{4}[foreAfter", "be\\Q{4}[\\Efore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before\fAfter", "\\f", "A", "before\f", "After");
        this.testBreak("before\fAfter", "[\\f\\r]", "A", "before\f", "After");
        this.testAssertionError("before before After", "\\Gbefore ", "A", "before before ", "After");
        this.testAssertionError("beforebeforeAfterAfterAfter", "before", "\\GAfter", "beforebefore", "AfterAfterAfter");
        this.testAssertionError("before before After after", "\\G[a-z ]", "A\\G[a-z ]", "before before ", "After after");
        this.testAssertionError("before before After", "\\G[a-z ]", "A", "before before ", "After");
        this.testBreak("before\nAfter", "\\n", "A", "before\n", "After");
        this.testBreak("before\nAfter", "[\\n\\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "[\\n\\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "\n", "A", "before\n", "After");
        this.testBreak("before\nAfter", "[\n\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "[\n\r]", "A", "before\r", "After");
        this.testPatternSyntaxException("before:After", "\\N{COLON}", "A", "before:", "After");
        this.testPatternSyntaxException("before:After", "re\\N{COLON}", "A", "before:", "After");
        this.testPatternSyntaxException("before\u00b8After", "\\N{CEDILLA}", "A", "before\u00b8", "After");
        this.testPatternSyntaxException("before\u00b8After", "[\\N{COLON}\\N{CEDILLA}]", "A", "before\u00b8", "After");
        this.testPatternSyntaxException("before0After", "\\N{DIGIT ZERO}", "A", "before0", "After");
        this.testPatternSyntaxException("before\u00e6After", "[\\N{LATIN SMALL LETTER AE}]", "A", "before\u00e6", "After");
        this.testPatternSyntaxException("before\u0438After", "\\p{Cyrillic}", "A", "before\u0438", "After");
        this.testPatternSyntaxException("before\u044a\u0438After", "\\p{Cyrillic}", "A", "before\u044a\u0438", "After");
        this.testPatternSyntaxException("before\u044a\u0438After", "\u044a\\p{Cyrillic}", "A", "before\u044a\u0438", "After");
        this.testPatternSyntaxException("abc\u0446\u044b\u043f\u0430After", "abc\u0446\u044b\\p{Cyrillic}{2}", "A", "abc\u0446\u044b\u043f\u0430", "After");
        this.testPatternSyntaxException("before\u0438After", "[\\p{Cyrillic}]", "A", "before\u0438", "After");
        this.testPatternSyntaxException("before\u0438After", "[\\p{Cyrillic}\r]", "A", "before\u0438", "After");
        this.testPatternSyntaxException("before\rAfter", "[\\p{Cyrillic}\r]", "A", "before\r", "After");
        this.testPatternSyntaxException("before\u0438bAfter", "\\P{Cyrillic}", "A", "before\u0438b", "After");
        this.testPatternSyntaxException("abc\u0446\u044bdaAfter", "abc\u0446\u044b\\P{Cyrillic}{2}", "A", "abc\u0446\u044bda", "After");
        this.testPatternSyntaxException("before\u0438bAfter", "[\\P{Cyrillic}]", "A", "before\u0438b", "After");
        this.testPatternSyntaxException("before\u0438bAfter", "[\\P{Cyrillic}\r]", "A", "before\u0438b", "After");
        this.testPatternSyntaxException("before\rAfter", "[\\P{Cyrillic}\r]", "A", "before\r", "After");
        this.testBreak("be{4}[foreAfter", "be\\Q{4}[\\Efore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before\rAfter", "\\r", "A", "before\r", "After");
        this.testBreak("before\rAfter", "[\\n\\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "[\\n\\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "\r", "A", "before\r", "After");
        this.testBreak("before\rAfter", "[\n\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "[\n\r]", "A", "before\n", "After");
        this.testBreak("before After", "\\s", "A", "before ", "After");
        this.testBreak("before\u3000After", "\\s", "A", "before\u3000", "After");
        this.testAssertionError("before\u200bAfter", "\\s", "A", "before\u200b", "After");
        this.testBreak("before\tAfter", "\\s", "A", "before\t", "After");
        this.testBreak("before After", "[\\s\\t]", "A", "before ", "After");
        this.testBreak("before\tAfter", "[\\s\\t]", "A", "before\t", "After");
        this.testBreak("   beforeAfter", "\\S", "A", "   before", "After");
        this.testBreak("   beforeAfter", "[\\S]", "A", "   before", "After");
        this.testBreak("   beforeAfter", "[\\S\\t]", "A", "   before", "After");
        this.testBreak("before\tAfter", "\\t", "A", "before\t", "After");
        this.testBreak("before\tAfter", "[\\t\\r]", "A", "before\t", "After");
        this.testBreak("before\tAfter", "e\\tA", "f", "before\tA", "fter");
        this.testBreak("before\u1234After", "\\u1234", "A", "before\u1234", "After");
        this.testPatternSyntaxException("before" + this.buildString(175) + "After", "\\U000000AF", "A", "before" + this.buildString(175), "After");
        this.testPatternSyntaxException("before" + this.buildString(175) + "After", "\\U000000af", "A", "before" + this.buildString(175), "After");
        this.testPatternSyntaxException("before" + this.buildString(65535) + "After", "\\U0000FFFF", "A", "before" + this.buildString(65535), "After");
        this.testPatternSyntaxException("before" + this.buildString(65536) + "After", "\\U00010000", "A", "before" + this.buildString(65536), "After");
        this.testPatternSyntaxException("before" + this.buildString(1092271) + "After", "\\U0010AAAF", "A", "before" + this.buildString(1092271), "After");
        this.testPatternSyntaxException("before" + this.buildString(1092271) + "After", "[\\U0010AAAF\\U00010000]", "A", "before" + this.buildString(1092271), "After");
        this.testPatternSyntaxException("before" + this.buildString(65536) + "After", "[\\U0010AAAF\\U00010000]", "A", "before" + this.buildString(65536), "After");
        this.testPatternSyntaxException("before" + this.buildString(68256) + "After", "[\\U0010AAAF\\U00010000-\\U00010AA1]", "A", "before" + this.buildString(68256), "After");
        this.testBreak("beforeAfter", "\\w", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\w\\r]", "A", "before", "After");
        this.testBreak("before\rAfter", "[\\w\\r]", "A", "before\r", "After");
        this.testBreak("before After", "\\W", "A", "before ", "After");
        this.testBreak("before After", "[\\W\\r]", "A", "before ", "After");
        this.testBreak("before\rAfter", "[\\W\\r]", "A", "before\r", "After");
        this.testPerlPatternSyntaxException("before\u00afAfter", "\\x{00AF}", "A", "before\u00af", "After");
        this.testPerlPatternSyntaxException("before\u00afAfter", "\\x{00af}", "A", "before\u00af", "After");
        this.testPerlPatternSyntaxException("before\u00afAfter", "\\x{af}", "A", "before\u00af", "After");
        this.testPerlPatternSyntaxException("before\u00afAfter", "[\\x{00AF}\\x{00AA}]", "A", "before\u00af", "After");
        this.testPerlPatternSyntaxException("before\u00aaAfter", "[\\x{00AF}\\x{00AA}]", "A", "before\u00aa", "After");
        this.testPerlPatternSyntaxException("before" + this.buildString(65535) + "After", "\\x{00FFFF}", "A", "before" + this.buildString(65535), "After");
        this.testPerlPatternSyntaxException("before" + this.buildString(0x10FFFF) + "After", "[\\x{10FFFF}\\x{10A000}]", "A", "before" + this.buildString(0x10FFFF), "After");
        this.testPerlPatternSyntaxException("before" + this.buildString(0x10A000) + "After", "[\\x{10FFFF}\\x{10A000}-\\x{10AA00}]", "A", "before" + this.buildString(0x10A000), "After");
        this.testBreak("before\u00afAfter", "\\xAF", "A", "before\u00af", "After");
        this.testBreak("before\u00afAfter", "[\\xAF\\xAA]", "A", "before\u00af", "After");
        this.testBreak("before\u00aaAfter", "[\\xAF\\xAA]", "A", "before\u00aa", "After");
        this.testPatternSyntaxException("beforeg\u0308After", "\\X", "A", "beforeg\u0308", "After");
        this.testPatternSyntaxException("beforeA\u0301After", "\\X", "A", "beforeA\u0301", "After");
        this.testPatternSyntaxException("beforeA\u0303After", "\\X", "A", "beforeA\u0303", "After");
        this.testPatternSyntaxException("before\u0e01\u0e47After", "\\X", "A", "before\u0e01\u0e47", "After");
        this.testBreak("before\u0f3fAfter", "\\u0F3F", "A", "before\u0f3f", "After");
        this.testPatternSyntaxException("before\u1100\u1161\u11a8After", "\\X", "A", "before\u1100\u1161\u11a8", "After");
        this.testPatternSyntaxException("before\u0ba8\u0bbfAfter", "\\X", "A", "before\u0ba8\u0bbf", "After");
        this.testPatternSyntaxException("before\u0937\u093fAfter", "\\X", "A", "before\u0937\u093f", "After");
        this.testPatternSyntaxException("before\u093fAfter", "\\X", "A", "before\u093f", "After");
        this.testPatternSyntaxException("before\u0915\u094d\u0937\u093fAfter", "\\X", "A", "before\u0915\u094d\u0937\u093f", "After");
        this.testBreak("terbefore\nAfter", "Af", "ter\\Z", "terbefore\nAf", "ter");
        this.testBreak("terbefore\nAfter\n", "Af", "ter\\Z", "terbefore\nAf", "ter\n");
        this.testBreak("terbefore\nAfter", "Af", "ter\\z", "terbefore\nAf", "ter");
        this.testNoBreak("terbefore\nAfter\n", "Af", "ter\\z", "terbefore\nAf", "ter\n");
        this.testAssertionError("before beforeAfter", "(before) \\1", "A", "before before", "After");
        this.testAssertionError("before before After", "(before) \\1", " A", "before before", " After");
        this.testAssertionError("before before After", "(before) \\1 ", "A", "before before ", "After");
        this.testPatternSyntaxException("before before\u0e01\u0e47After", "(before) \\1\\X?", "A", "before before\u0e01\u0e47", "After");
        this.testPatternSyntaxException("before before \u0e01\u0e47After", "(before) \\1 \\X?", "A", "before before \u0e01\u0e47", "After");
        this.testPatternSyntaxException("before before After", "(before) \\1 \\X?", "A", "before before ", "After");
        this.testPatternSyntaxException("before beforeAfter", "(before) \\1\\X?", "A", "before before", "After");
        this.testBreak("before\nAfter", "\\012", "A", "before\n", "After");
        this.testBreak("before\u000bAfter", "\\013", "A", "before\u000b", "After");
        this.testBreak("before\rAfter", "e", "\\015", "before", "\rAfter");
        this.testBreak("before\u0018After", "\\030", "A", "before\u0018", "After");
        this.testBreak("before\u001aAfter", "\\032", "A", "before\u001a", "After");
        this.testBreak("before*After", "\\052", "A", "before*", "After");
        this.testBreak("before?After", "\\077", "A", "before?", "After");
        this.testBreak("before@After", "\\0100", "A", "before@", "After");
        this.testBreak("before\u00aaAfter", "\\0252", "A", "before\u00aa", "After");
        this.testBreak("beforePAfter", "e", "\\0120", "before", "PAfter");
        this.testBreak("before\u00ffAfter", "e", "\\0377", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377]", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377\\077]", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377\\077]", "before", "\u00ffAfter");
        this.testNoBreak("before?After", "e", "\\0477", "before", "?After");
        this.testPatternSyntaxException("be\u0444\u044b\u0432\u0430fore\nAfter", "[a-z\\p{Cyrillic}]+", "ore", "be\u0444\u044b\u0432\u0430f", "ore\nAfter");
        this.testBreak("before\nAfter", ".", "ore", "bef", "ore\nAfter");
        this.testBreak("before\nAfter", "^bef", "ore", "bef", "ore\nAfter");
        this.testBreak("terbefore\nAfter", "Af", "ter$", "terbefore\nAf", "ter");
        this.testBreak("be{4}[foreAfter", "be\\{4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\{\\[]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\{\\[]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before After", " ", "A", "before ", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "e\bA", "f", "before\bA", "fter");
    }

    @Test
    public void testMetachars2() {
        this.testBreak("Mr. Holmes is from the U.K. not the U.S. Is Dr. Watson from there too? Yes: both are.", "\\b(St|Gen|Hon|Dr|Mr|Ms|Mrs|Col|Maj|Brig|Sgt|Capt|Cmnd|Sen|Rev|Rep|Revd)\\.", "\\s+\\p{Lu}", "Mr.", " Holmes is from the U.K. not the U.S. Is Dr.", 3);
    }

    private String buildString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf((char)codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    private void testBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)2L, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)beforeBreak, (Object)tc.getSegments().get(0).toString());
        Assert.assertEquals((Object)afterBreak, (Object)tc.getSegments().get(1).toString());
    }

    private void testAssertionError(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        try {
            this.testBreak(text, bbr, abr, beforeBreak, afterBreak);
            throw new Error();
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    private void testPatternSyntaxException(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        if (!JAVA_VERSION.startsWith("1.")) {
            return;
        }
        try {
            this.testBreak(text, bbr, abr, beforeBreak, afterBreak);
            Assert.fail();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    static boolean isJdk7OrUp() {
        if (isJdk7Tested) {
            return isJdk7;
        }
        isJdk7Tested = true;
        isJdk7 = true;
        String[] verParts = JAVA_VERSION.split("\\.");
        if (verParts.length < 2) {
            return isJdk7;
        }
        int vmajor = -1;
        int vminor = -1;
        try {
            vmajor = Integer.parseInt(verParts[0]);
            vminor = Integer.parseInt(verParts[1]);
        }
        catch (NumberFormatException e) {
            return isJdk7;
        }
        if (vmajor > 2) {
            return isJdk7;
        }
        if (vminor >= 7) {
            return isJdk7;
        }
        isJdk7 = false;
        return isJdk7;
    }

    private void testPerlPatternSyntaxException(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        block3: {
            boolean supported = TestJavaRegex.isJdk7OrUp();
            try {
                this.testBreak(text, bbr, abr, beforeBreak, afterBreak);
                if (!supported) {
                    Assert.fail();
                }
            }
            catch (PatternSyntaxException e) {
                if (!supported) break block3;
                Assert.fail();
            }
        }
    }

    private void testBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak, int numSeg) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)numSeg, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)beforeBreak, (Object)tc.getSegments().get(0).toString());
        Assert.assertEquals((Object)afterBreak, (Object)tc.getSegments().get(1).toString());
    }

    private void testNoBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)1L, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)text, (Object)tc.getSegments().get(0).toString());
    }
}

