/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.ArrayList;
import java.util.TreeSet;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestJava7Regex {
    private SRXSegmenter segmenter;
    private SRXDocument doc;
    private ArrayList<Rule> rules;

    @Before
    public void startUp() {
        this.doc = new SRXDocument();
        this.segmenter = new SRXSegmenter();
        this.rules = new ArrayList();
        Assert.assertTrue((boolean)this.segmenter.useJavaRegex());
    }

    @Test
    public void testSet() {
        TreeSet<Character> set = new TreeSet<Character>();
        set.add(Character.valueOf('w'));
        set.add(Character.valueOf('a'));
        set.add(Character.valueOf('x'));
        set.add(Character.valueOf('t'));
        set.add(Character.valueOf('s'));
        char[] chars = new char[set.size()];
        int i = 0;
        for (Character ch : set) {
            chars[i++] = ch.charValue();
        }
        Assert.assertEquals((Object)"astwx", (Object)String.valueOf(chars));
    }

    @Test
    public void testMetachars() {
        this.testBreak("before\u0007After", "\\a", "A", "before\u0007", "After");
        this.testBreak("before\u0007After", "[\\a ]", "A", "before\u0007", "After");
        this.testBreak("before_After", "[\\a_]", "A", "before_", "After");
        this.testBreak("before After", "[\\a ]", "A", "before ", "After");
        this.testBreak("After", "\\AA", "f", "A", "fter");
        this.testBreak("before\nAfter", "\\Abef", "ore", "bef", "ore\nAfter");
        this.testBreak("before After", "\\b", "A", "before ", "After");
        this.testBreak("before After", "\\b", " ", "before", " After");
        this.testBreak("before\rAfter", "\\b", "\r", "before", "\rAfter");
        this.testBreak("before After", "\\b", "A", "before ", "After");
        this.testBreak("before After", "\\b", " ", "before", " After");
        this.testBreak("before After", "\\b|\\r", "A", "before ", "After");
        this.testBreak("before\rAfter", "\\b|\\r", "A", "before\r", "After");
        this.testBreak("before afAter", "\\B", "A", "before af", "Ater");
        this.testBreak("before after", "\\B", "o", "bef", "ore after");
        this.testBreak("befo\rreAfter", "\\B", "A", "befo\rre", "After");
        this.testBreak("before afAter", "\\B", "A", "before af", "Ater");
        this.testBreak("before after", "\\B", "o", "bef", "ore after");
        this.testBreak("before after", "\\B|\\r", "o", "bef", "ore after");
        this.testBreak("beforeAfter", "\\Be", "A", "before", "After");
        this.testBreak("before\rAfter", "\\B|\\r", "A", "before\r", "After");
        this.testBreak("before\u0001After", "\\cA", "A", "before\u0001", "After");
        this.testBreak("before\u0002After", "\\cB", "A", "before\u0002", "After");
        this.testBreak("before\u0003After", "\\cC", "A", "before\u0003", "After");
        this.testBreak("before\u0004After", "\\cD", "A", "before\u0004", "After");
        this.testBreak("before\u0005After", "\\cE", "A", "before\u0005", "After");
        this.testBreak("before\u0006After", "\\cF", "A", "before\u0006", "After");
        this.testBreak("before\u0007After", "\\cG", "A", "before\u0007", "After");
        this.testBreak("before\bAfter", "\\cH", "A", "before\b", "After");
        this.testBreak("before\tAfter", "\\cI", "A", "before\t", "After");
        this.testBreak("before\nAfter", "\\cJ", "A", "before\n", "After");
        this.testBreak("before\u000bAfter", "\\cK", "A", "before\u000b", "After");
        this.testBreak("before\fAfter", "\\cL", "A", "before\f", "After");
        this.testBreak("before\rAfter", "\\cM", "A", "before\r", "After");
        this.testBreak("before\u000eAfter", "\\cN", "A", "before\u000e", "After");
        this.testBreak("before\u000fAfter", "\\cO", "A", "before\u000f", "After");
        this.testBreak("before\u0010After", "\\cP", "A", "before\u0010", "After");
        this.testBreak("before\u0011After", "\\cQ", "A", "before\u0011", "After");
        this.testBreak("before\u0012After", "\\cR", "A", "before\u0012", "After");
        this.testBreak("before\u0013After", "\\cS", "A", "before\u0013", "After");
        this.testBreak("before\u0014After", "\\cT", "A", "before\u0014", "After");
        this.testBreak("before\u0015After", "\\cU", "A", "before\u0015", "After");
        this.testBreak("before\u0016After", "\\cV", "A", "before\u0016", "After");
        this.testBreak("before\u0017After", "\\cW", "A", "before\u0017", "After");
        this.testBreak("before\u0018After", "\\cX", "A", "before\u0018", "After");
        this.testBreak("before\u0019After", "\\cY", "A", "before\u0019", "After");
        this.testBreak("before\u001aAfter", "\\cZ", "A", "before\u001a", "After");
        this.testBreak("before\u001aAfter", "[\\cZ\\cA]", "A", "before\u001a", "After");
        this.testBreak("before\u0001After", "[\\cZ\\cA]", "A", "before\u0001", "After");
        this.testBreak("before001After", "\\d", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "\\d", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "[\\d]", "A", "before001", "After");
        this.testBreak("before\u0969After", "\\d", "A", "before\u0969", "After");
        this.testBreak("before001After", "[\\d]", "A", "before001", "After");
        this.testBreak("before001After", "[\\d\\r]", "A", "before001", "After");
        this.testNoBreak("beforeAfter", "[\\d\\r]", "A", "before001", "After");
        this.testBreak("before\u0969After", "[\\d\\r]", "A", "before\u0969", "After");
        this.testBreak("before\rAfter", "[\\d\\r]", "A", "before\r", "After");
        this.testBreak("beforeAfter", "\\D", "A", "before", "After");
        this.testNoBreak("before\u0969After", "\\D", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\D]", "A", "before", "After");
        this.testNoBreak("before\u0969After", "[\\D]", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\D\\r]", "A", "before", "After");
        this.testNoBreak("before\u0969After", "[\\D\\r]", "A", "before", "After");
        this.testBreak("before\rAfter", "[\\D\\r]", "A", "before\r", "After");
        this.testBreak("before\u001bAfter", "\\e", "A", "before\u001b", "After");
        this.testBreak("before\u001bAfter", "[\\e\\r]", "A", "before\u001b", "After");
        this.testBreak("be{4}[foreAfter", "be\\Q{4}[\\Efore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before\fAfter", "\\f", "A", "before\f", "After");
        this.testBreak("before\fAfter", "[\\f\\r]", "A", "before\f", "After");
        this.testBreak("before\nAfter", "\\n", "A", "before\n", "After");
        this.testBreak("before\nAfter", "[\\n\\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "[\\n\\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "\n", "A", "before\n", "After");
        this.testBreak("before\nAfter", "[\n\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "[\n\r]", "A", "before\r", "After");
        this.testBreak("before\u0438After", "\\p{IsCyrillic}", "A", "before\u0438", "After");
        this.testBreak("before\u044a\u0438After", "\\p{IsCyrillic}", "A", "before\u044a\u0438", "After");
        this.testBreak("before\u044a\u0438After", "\u044a\\p{IsCyrillic}", "A", "before\u044a\u0438", "After");
        this.testBreak("abc\u0446\u044b\u043f\u0430After", "abc\u0446\u044b\\p{IsCyrillic}{2}", "A", "abc\u0446\u044b\u043f\u0430", "After");
        this.testBreak("before\u0438After", "[\\p{IsCyrillic}]", "A", "before\u0438", "After");
        this.testBreak("before\u0438After", "[\\p{IsCyrillic}\r]", "A", "before\u0438", "After");
        this.testBreak("before\rAfter", "[\\p{IsCyrillic}\r]", "A", "before\r", "After");
        this.testBreak("before\u0438bAfter", "\\P{IsCyrillic}", "A", "before\u0438b", "After");
        this.testBreak("abc\u0446\u044bdaAfter", "abc\u0446\u044b\\P{IsCyrillic}{2}", "A", "abc\u0446\u044bda", "After");
        this.testBreak("before\u0438bAfter", "[\\P{IsCyrillic}]", "A", "before\u0438b", "After");
        this.testBreak("before\u0438bAfter", "[\\P{IsCyrillic}\r]", "A", "before\u0438b", "After");
        this.testBreak("before\rAfter", "[\\P{IsCyrillic}\r]", "A", "before\r", "After");
        this.testBreak("be{4}[foreAfter", "be\\Q{4}[\\Efore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\Q{[\\E]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before\rAfter", "\\r", "A", "before\r", "After");
        this.testBreak("before\rAfter", "[\\n\\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "[\\n\\r]", "A", "before\n", "After");
        this.testBreak("before\rAfter", "\r", "A", "before\r", "After");
        this.testBreak("before\rAfter", "[\n\r]", "A", "before\r", "After");
        this.testBreak("before\nAfter", "[\n\r]", "A", "before\n", "After");
        this.testBreak("before After", "\\s", "A", "before ", "After");
        this.testBreak("before\u3000After", "\\s", "A", "before\u3000", "After");
        this.testBreak("before\u2009After", "\\s", "A", "before\u2009", "After");
        this.testBreak("before\tAfter", "\\s", "A", "before\t", "After");
        this.testBreak("before After", "[\\s\\t]", "A", "before ", "After");
        this.testBreak("before\tAfter", "[\\s\\t]", "A", "before\t", "After");
        this.testBreak("   beforeAfter", "\\S", "A", "   before", "After");
        this.testBreak("   beforeAfter", "[\\S]", "A", "   before", "After");
        this.testBreak("   beforeAfter", "[\\S\\t]", "A", "   before", "After");
        this.testBreak("before\tAfter", "\\t", "A", "before\t", "After");
        this.testBreak("before\tAfter", "[\\t\\r]", "A", "before\t", "After");
        this.testBreak("before\tAfter", "e\\tA", "f", "before\tA", "fter");
        this.testBreak("before\u1234After", "\\u1234", "A", "before\u1234", "After");
        this.testBreak("beforeAfter", "\\w", "A", "before", "After");
        this.testBreak("beforeAfter", "[\\w\\r]", "A", "before", "After");
        this.testBreak("before\rAfter", "[\\w\\r]", "A", "before\r", "After");
        this.testBreak("before After", "\\W", "A", "before ", "After");
        this.testBreak("before After", "[\\W\\r]", "A", "before ", "After");
        this.testBreak("before\rAfter", "[\\W\\r]", "A", "before\r", "After");
        this.testBreak("before\u00afAfter", "\\x{00AF}", "A", "before\u00af", "After");
        this.testBreak("before\u00afAfter", "\\x{00af}", "A", "before\u00af", "After");
        this.testBreak("before\u00afAfter", "\\x{af}", "A", "before\u00af", "After");
        this.testBreak("before\u00afAfter", "[\\x{00AF}\\x{00AA}]", "A", "before\u00af", "After");
        this.testBreak("before\u00aaAfter", "[\\x{00AF}\\x{00AA}]", "A", "before\u00aa", "After");
        this.testBreak("before" + this.buildString(65535) + "After", "\\x{00FFFF}", "A", "before" + this.buildString(65535), "After");
        this.testBreak("before" + this.buildString(0x10FFFF) + "After", "[\\x{10FFFF}\\x{10A000}]", "A", "before" + this.buildString(0x10FFFF), "After");
        this.testBreak("before" + this.buildString(0x10A000) + "After", "[\\x{10FFFF}\\x{10A000}-\\x{10AA00}]", "A", "before" + this.buildString(0x10A000), "After");
        this.testBreak("before\u00afAfter", "\\xAF", "A", "before\u00af", "After");
        this.testBreak("before\u00afAfter", "[\\xAF\\xAA]", "A", "before\u00af", "After");
        this.testBreak("before\u00aaAfter", "[\\xAF\\xAA]", "A", "before\u00aa", "After");
        this.testBreak("beforeg\u0308After", "(?:(?:\\u000D\\u000A)|(?:[\\u0E40\\u0E41\\u0E42\\u0E43\\u0E44\\u0EC0\\u0EC1\\u0EC2\\u0EC3\\u0EC4\\uAAB5\\uAAB6\\uAAB9\\uAABB\\uAABC]*(?:[\\u1100-\\u115F\\uA960-\\uA97C]+|([\\u1100-\\u115F\\uA960-\\uA97C]*((?:[[\\u1160-\\u11A2\\uD7B0-\\uD7C6][\\uAC00\\uAC1C\\uAC38]][\\u1160-\\u11A2\\uD7B0-\\uD7C6]*|[\\uAC01\\uAC02\\uAC03\\uAC04])[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]*))|[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]+|[^[\\p{Zl}\\p{Zp}\\p{Cc}\\p{Cf}&&[^\\u000D\\u000A\\u200C\\u200D]]\\u000D\\u000A])[[\\p{Mn}\\p{Me}\\u200C\\u200D\\u0488\\u0489\\u20DD\\u20DE\\u20DF\\u20E0\\u20E2\\u20E3\\u20E4\\uA670\\uA671\\uA672\\uFF9E\\uFF9F][\\p{Mc}\\u0E30\\u0E32\\u0E33\\u0E45\\u0EB0\\u0EB2\\u0EB3]]*)|(?s:.))", "A", "beforeg\u0308", "After");
        this.testBreak("beforeA\u0301After", "(?>\\PM*\\pM*)", "A", "beforeA\u0301", "After");
        this.testBreak("beforeA\u0303After", "(?>\\PM*\\pM*)", "A", "beforeA\u0303", "After");
        this.testBreak("before\u0e01\u0e47After", "(?>\\PM\\pM*)", "A", "before\u0e01\u0e47", "After");
        this.testBreak("before\u0f3fAfter", "\\u0F3F", "A", "before\u0f3f", "After");
        this.testBreak("before\u1100\u1161\u11a8After", "(?>\\PM\\pM*)", "A", "before\u1100\u1161\u11a8", "After");
        this.testBreak("before\u0ba8\u0bbfAfter", "(?>\\PM\\pM*)", "A", "before\u0ba8\u0bbf", "After");
        this.testBreak("before\u0937\u093fAfter", "(?>\\PM\\pM*)", "A", "before\u0937\u093f", "After");
        this.testBreak("before\u093fAfter", "(?>\\PM\\pM*)", "A", "before\u093f", "After");
        this.testBreak("before\u0915\u094d\u0937\u093fAfter", "(?:(?:\\u000D\\u000A)|(?:[\\u0E40\\u0E41\\u0E42\\u0E43\\u0E44\\u0EC0\\u0EC1\\u0EC2\\u0EC3\\u0EC4\\uAAB5\\uAAB6\\uAAB9\\uAABB\\uAABC]*(?:[\\u1100-\\u115F\\uA960-\\uA97C]+|([\\u1100-\\u115F\\uA960-\\uA97C]*((?:[[\\u1160-\\u11A2\\uD7B0-\\uD7C6][\\uAC00\\uAC1C\\uAC38]][\\u1160-\\u11A2\\uD7B0-\\uD7C6]*|[\\uAC01\\uAC02\\uAC03\\uAC04])[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]*))|[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]+|[^[\\p{Zl}\\p{Zp}\\p{Cc}\\p{Cf}&&[^\\u000D\\u000A\\u200C\\u200D]]\\u000D\\u000A])[[\\p{Mn}\\p{Me}\\u200C\\u200D\\u0488\\u0489\\u20DD\\u20DE\\u20DF\\u20E0\\u20E2\\u20E3\\u20E4\\uA670\\uA671\\uA672\\uFF9E\\uFF9F][\\p{Mc}\\u0E30\\u0E32\\u0E33\\u0E45\\u0EB0\\u0EB2\\u0EB3]]*)|(?s:.))", "A", "before\u0915\u094d\u0937\u093f", "After");
        this.testBreak("terbefore\nAfter", "Af", "ter\\Z", "terbefore\nAf", "ter");
        this.testBreak("terbefore\nAfter\n", "Af", "ter\\Z", "terbefore\nAf", "ter\n");
        this.testBreak("terbefore\nAfter", "Af", "ter\\z", "terbefore\nAf", "ter");
        this.testNoBreak("terbefore\nAfter\n", "Af", "ter\\z", "terbefore\nAf", "ter\n");
        this.testBreak("before beforeAfter", "(before) \\2", "A", "before before", "After");
        this.testBreak("before before After", "(before) \\2", " A", "before before", " After");
        this.testBreak("before before After", "(before) \\2 ", "A", "before before ", "After");
        this.testBreak("before before\u0e01\u0e47After", "(before) \\2(?>\\PM\\pM*)?", "A", "before before\u0e01\u0e47", "After");
        this.testBreak("before before \u0e01\u0e47After", "(before) \\2 (?>\\PM\\pM*)?", "A", "before before \u0e01\u0e47", "After");
        this.testBreak("before before After", "(before) \\2 (?>\\PM\\pM*)?", "A", "before before ", "After");
        this.testBreak("before beforeAfter", "(before) \\2(?>\\PM\\pM*)?", "A", "before before", "After");
        this.testBreak("before\nAfter", "\\012", "A", "before\n", "After");
        this.testBreak("before\u000bAfter", "\\013", "A", "before\u000b", "After");
        this.testBreak("before\rAfter", "e", "\\015", "before", "\rAfter");
        this.testBreak("before\u0018After", "\\030", "A", "before\u0018", "After");
        this.testBreak("before\u001aAfter", "\\032", "A", "before\u001a", "After");
        this.testBreak("before*After", "\\052", "A", "before*", "After");
        this.testBreak("before?After", "\\077", "A", "before?", "After");
        this.testBreak("before@After", "\\0100", "A", "before@", "After");
        this.testBreak("before\u00aaAfter", "\\0252", "A", "before\u00aa", "After");
        this.testBreak("beforePAfter", "e", "\\0120", "before", "PAfter");
        this.testBreak("before\u00ffAfter", "e", "\\0377", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377]", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377\\077]", "before", "\u00ffAfter");
        this.testBreak("before\u00ffAfter", "e", "[\\0377\\077]", "before", "\u00ffAfter");
        this.testNoBreak("before?After", "e", "\\0477", "before", "?After");
        this.testBreak("be\u0444\u044b\u0432\u0430fore\nAfter", "[a-z\\p{IsCyrillic}]+", "ore", "be\u0444\u044b\u0432\u0430f", "ore\nAfter");
        this.testBreak("before\nAfter", ".", "ore", "bef", "ore\nAfter");
        this.testBreak("before\nAfter", "^bef", "ore", "bef", "ore\nAfter");
        this.testBreak("terbefore\nAfter", "Af", "ter$", "terbefore\nAf", "ter");
        this.testBreak("be{4}[foreAfter", "be\\{4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be{4}[foreAfter", "be[\\{\\[]4\\}\\[fore", "A", "be{4}[fore", "After");
        this.testBreak("be[4}[foreAfter", "be[\\{\\[]4\\}\\[fore", "A", "be[4}[fore", "After");
        this.testBreak("before After", " ", "A", "before ", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "\b", "A", "before\b", "After");
        this.testBreak("before\bAfter", "e\bA", "f", "before\bA", "fter");
        this.testBreak("Sentence 1. Sentence 2.", "\\.", "\\s|<br/?>", "Sentence 1.", " Sentence 2.");
        this.testBreak("Sentence 1.<br>Sentence 2.", "\\.", "\\s|<br/?>", "Sentence 1.", "<br>Sentence 2.");
        this.testBreak("Sentence 1.<br/>Sentence 2.", "\\.", "\\s|<br/?>", "Sentence 1.", "<br/>Sentence 2.");
    }

    @Test
    public void testMetachars2() {
        this.testBreak("Mr. Holmes is from the U.K. not the U.S. Is Dr. Watson from there too? Yes: both are.", "\\b(St|Gen|Hon|Dr|Mr|Ms|Mrs|Col|Maj|Brig|Sgt|Capt|Cmnd|Sen|Rev|Rep|Revd)\\.", "\\s+\\p{Lu}", "Mr.", " Holmes is from the U.K. not the U.S. Is Dr.", 3);
    }

    private String buildString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf((char)codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    private void testBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)2L, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)beforeBreak, (Object)tc.getSegments().get(0).toString());
        Assert.assertEquals((Object)afterBreak, (Object)tc.getSegments().get(1).toString());
    }

    private void testBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak, int numSeg) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)numSeg, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)beforeBreak, (Object)tc.getSegments().get(0).toString());
        Assert.assertEquals((Object)afterBreak, (Object)tc.getSegments().get(1).toString());
    }

    private void testNoBreak(String text, String bbr, String abr, String beforeBreak, String afterBreak) {
        this.rules.clear();
        this.rules.add(new Rule(bbr, abr, true));
        this.doc.addLanguageRule("default", this.rules);
        this.doc.addLanguageMap(new LanguageMap(".*", "default"));
        this.segmenter.setLanguage(null);
        this.doc.compileLanguageRules(LocaleId.ENGLISH, (ISegmenter)this.segmenter);
        Assert.assertEquals((long)1L, (long)this.segmenter.computeSegments(text));
        TextContainer tc = new TextContainer(text);
        tc.getSegments().create(this.segmenter.getRanges());
        Assert.assertEquals((Object)text, (Object)tc.getSegments().get(0).toString());
    }
}

