/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SegmentationTest {
    private ISegmenter segmenter;
    private ISegmenter segmenterTrim;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private GenericContent fmt = new GenericContent();
    private LocaleId locFR = LocaleId.FRENCH;
    private LocaleId locAR = LocaleId.ARABIC;

    @Before
    public void setUp() {
        SRXDocument doc1 = new SRXDocument();
        LanguageMap langMap = new LanguageMap(".*", "default");
        doc1.addLanguageMap(langMap);
        ArrayList<Rule> langRules = new ArrayList<Rule>();
        langRules.add(new Rule("\\.", "\\s", true));
        langRules.add(new Rule("\\|", "", true));
        doc1.addLanguageRule("default", langRules);
        this.segmenter = doc1.compileLanguageRules(this.locEN, null);
        SRXDocument doc2 = new SRXDocument();
        doc2.addLanguageMap(langMap);
        doc2.addLanguageRule("default", langRules);
        doc2.setTrimLeadingWhitespaces(true);
        doc2.setTrimTrailingWhitespaces(true);
        this.segmenterTrim = doc2.compileLanguageRules(this.locEN, null);
    }

    @Test
    public void testGetSegmentCount() {
        TextContainer tc = this.createSegmentedContainer();
        Assert.assertEquals((long)2L, (long)tc.getSegments().count());
    }

    @Test
    public void testGetSegments() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        Assert.assertEquals((Object)"<s>Part 1.</s>", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)" Part 2.", (Object)segments.get(1).toString());
        Assert.assertEquals((Object)"[<1>Part 1.</1>] Outside[ Part 2.]", (Object)this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testMergeOneSegment() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        Assert.assertEquals((Object)"[<1>Part 1.</1>] Outside[ Part 2.]", (Object)this.fmt.printSegmentedContent(tc, true));
        tc.changePart(2);
        Assert.assertEquals((long)1L, (long)segments.count());
        Assert.assertEquals((Object)"<s>Part 1.</s>", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)"[<1>Part 1.</1>] Outside Part 2.", (Object)this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testChangeTwoSegmentsToParts() {
        TextContainer tc = this.createSegmentedContainer();
        tc.changePart(2);
        tc.changePart(0);
        Assert.assertEquals((long)1L, (long)tc.getSegments().count());
        Assert.assertFalse((boolean)tc.contentIsOneSegment());
        Assert.assertEquals((Object)"[<1>Part 1.</1>] Outside Part 2.", (Object)this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals((Object)"<s>Part 1.</s> Outside Part 2.", (Object)tc.toString());
    }

    @Test
    public void testJoinTwoSegmentsIntoOne() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        segments.joinWithNext(0);
        Assert.assertEquals((long)1L, (long)segments.count());
        Assert.assertTrue((boolean)tc.contentIsOneSegment());
        Assert.assertEquals((Object)"[<1>Part 1.</1> Outside Part 2.]", (Object)this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals((Object)"<s>Part 1.</s> Outside Part 2.", (Object)tc.toString());
    }

    @Test
    public void testMergeAllSegments() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        segments.joinAll();
        Assert.assertEquals((long)1L, (long)segments.count());
        Assert.assertTrue((boolean)tc.contentIsOneSegment());
        Assert.assertEquals((Object)"[<1>Part 1.</1> Outside Part 2.]", (Object)this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals((Object)"<s>Part 1.</s> Outside Part 2.", (Object)tc.toString());
    }

    @Test
    public void testCreateSegment() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        segments.create(11, 19);
        Assert.assertEquals((long)1L, (long)segments.count());
        Assert.assertEquals((long)3L, (long)tc.count());
        Assert.assertEquals((Object)" Outside", (Object)segments.get(0).toString());
    }

    @Test
    public void testAppendSegment() {
        TextContainer tc = this.createSegmentedContainer();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment(" Added Part."));
        Assert.assertEquals((long)3L, (long)segments.count());
        Assert.assertEquals((Object)" Added Part.", (Object)segments.get(2).toString());
    }

    @Test
    public void testSegmentationSimple1() {
        TextContainer tc = this.createSegmentedContainer("a. z", this.segmenter);
        ISegments segments = tc.getSegments();
        Assert.assertEquals((long)2L, (long)segments.count());
        Assert.assertEquals((Object)"a.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)" z", (Object)segments.get(1).toString());
        tc = this.createSegmentedContainer("a. z", this.segmenterTrim);
        segments = tc.getSegments();
        Assert.assertEquals((long)2L, (long)segments.count());
        Assert.assertEquals((Object)"a.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)"z", (Object)segments.get(1).toString());
    }

    @Test
    public void testSegmentationSimpleWithLeadingTrainlingWS() {
        TextContainer tc = this.createSegmentedContainer(" a.  ", this.segmenter);
        ISegments segments = tc.getSegments();
        Assert.assertEquals((long)2L, (long)segments.count());
        Assert.assertEquals((Object)" a.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)"  ", (Object)segments.get(1).toString());
        tc = this.createSegmentedContainer("a. ", this.segmenterTrim);
        segments = tc.getSegments();
        Assert.assertEquals((long)1L, (long)segments.count());
        Assert.assertEquals((Object)"a.", (Object)segments.get(0).toString());
    }

    @Test
    public void testSegmentationWithEmpty() {
        TextContainer tc = this.createSegmentedContainer(" a. | b.", this.segmenter);
        ISegments segments = tc.getSegments();
        Assert.assertEquals((long)3L, (long)segments.count());
        Assert.assertEquals((Object)" a.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)" |", (Object)segments.get(1).toString());
        Assert.assertEquals((Object)" b.", (Object)segments.get(2).toString());
        tc = this.createSegmentedContainer(" a. |  b.", this.segmenterTrim);
        segments = tc.getSegments();
        Assert.assertEquals((long)3L, (long)segments.count());
        Assert.assertEquals((Object)"a.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)"|", (Object)segments.get(1).toString());
        Assert.assertEquals((Object)"b.", (Object)segments.get(2).toString());
    }

    @Test
    public void testTrimOptionsSetting() {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.setTrimLeadingWhitespaces(true);
        srxDoc.setTrimTrailingWhitespaces(true);
        ISegmenter segter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        segter.computeSegments(" a ");
        List list = segter.getRanges();
        Assert.assertEquals((long)1L, (long)((Range)list.get((int)0)).start);
        Assert.assertEquals((long)2L, (long)((Range)list.get((int)0)).end);
        String tmpPath = FileLocation.fromClass(SegmentationTest.class).out("/tmp.srx").toString();
        srxDoc.saveRules(tmpPath, true, true);
        srxDoc.resetAll();
        segter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        segter.computeSegments(" a ");
        list = segter.getRanges();
        Assert.assertEquals((long)0L, (long)((Range)list.get((int)0)).start);
        Assert.assertEquals((long)3L, (long)((Range)list.get((int)0)).end);
        srxDoc.loadRules(tmpPath);
        segter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        segter.computeSegments(" a ");
        list = segter.getRanges();
        Assert.assertEquals((long)1L, (long)((Range)list.get((int)0)).start);
        Assert.assertEquals((long)2L, (long)((Range)list.get((int)0)).end);
    }

    @Test
    public void testTrimOptionsSettingFromFile() {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules(SRXSegmenter.class.getClassLoader().getResourceAsStream("net/sf/okapi/lib/segmentation/defaultSegmentation.srx"));
        ISegmenter segter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        segter.computeSegments(" a ");
        List list = segter.getRanges();
        Assert.assertEquals((long)1L, (long)((Range)list.get((int)0)).start);
        Assert.assertEquals((long)2L, (long)((Range)list.get((int)0)).end);
    }

    @Test
    public void testTUCreateSourceSegmentation() {
        TextUnit tu = new TextUnit("tuid");
        tu.setSource(this.createSimpleContent());
        tu.createSourceSegmentation(this.segmenter);
        Assert.assertEquals((Object)"[<1>Part 1.</1>][ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
    }

    @Test
    public void testTUCreateSourceSegmentationOverwrite() {
        TextUnit tu = new TextUnit("tuid");
        tu.setSource(this.createSegmentedContainer());
        Assert.assertEquals((Object)"[<1>Part 1.</1>] Outside[ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        tu.createSourceSegmentation(this.segmenter);
        Assert.assertEquals((Object)"[<1>Part 1.</1>][ Outside Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
    }

    @Test
    public void testTUSourceSegmentationInTarget() {
        TextUnit tu = new TextUnit("tuid");
        tu.setSource(this.createSimpleContent());
        tu.createSourceSegmentation(this.segmenter);
        Assert.assertEquals((Object)"[<1>Part 1.</1>][ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        TextContainer tc = tu.createTarget(this.locFR, true, 7);
        for (Segment seg : tc.getSegments()) {
            seg.text.setCodedText(seg.text.getCodedText().toUpperCase() + " FR");
        }
        Assert.assertEquals((Object)"[<1>PART 1.</1> FR][ PART 2. FR]", (Object)this.fmt.printSegmentedContent(tc, true));
    }

    @Test
    public void testCreateTargetSegmentation() {
        TextUnit tu = new TextUnit("tuid");
        tu.setSource(this.createSimpleContent());
        tu.createTarget(this.locFR, true, 7);
        tu.createSourceSegmentation(this.segmenter);
        tu.createTargetSegmentation(this.segmenter, this.locFR);
        Assert.assertEquals((Object)"[<1>Part 1.</1>][ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[<1>Part 1.</1>][ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true));
    }

    @Test
    public void testCreateSegmentationWithCodes() {
        TextUnit tu = new TextUnit("tuid");
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "s", "<s>");
        tf.append("Part 1");
        tf.append(TextFragment.TagType.CLOSING, "s", "</s>");
        tf.append(". Part 2.");
        tu.setSource(new TextContainer(tf));
        tu.createSourceSegmentation(this.segmenter);
        Assert.assertEquals((Object)"[<1>Part 1</1>.][ Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
    }

    @Test
    public void testSegmentationWithEmptyString() {
        TextContainer tc = this.createSegmentedContainer("", this.segmenter);
        ISegments segments = tc.getSegments();
        Assert.assertEquals((long)1L, (long)segments.count());
    }

    @Test
    public void testTestWithEmbededSegmentationFile() {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules(SRXDocument.class.getResourceAsStream("defaultSegmentation.srx"));
        ISegmenter segter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        TextContainer tc = new TextContainer("Sentence one. And sentence two.");
        segter.computeSegments(tc);
        tc.getSegments().create(segter.getRanges());
        Assert.assertEquals((Object)"[Sentence one.] [And sentence two.]", (Object)this.fmt.printSegmentedContent(tc, true));
    }

    private TextContainer createSimpleContent() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "s", "<s>");
        tf.append("Part 1.");
        tf.append(TextFragment.TagType.CLOSING, "s", "</s>");
        tf.append(" Part 2.");
        return new TextContainer(tf);
    }

    private TextContainer createSegmentedContainer() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "s", "<s>");
        tf.append("Part 1.");
        tf.append(TextFragment.TagType.CLOSING, "s", "</s>");
        tf.append(" Part 2.");
        TextContainer tc = new TextContainer(tf);
        this.segmenter.computeSegments(tc);
        tc.getSegments().create(this.segmenter.getRanges());
        tc.insert(1, new TextPart(new TextFragment(" Outside")));
        return tc;
    }

    private TextContainer createSegmentedContainer(String text, ISegmenter segmenter) {
        TextContainer tc = new TextContainer(text);
        segmenter.computeSegments(tc);
        tc.getSegments().create(segmenter.getRanges());
        return tc;
    }
}

