/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import net.sf.okapi.lib.segmentation.OkapiSegmenter;
import net.sf.okapi.lib.segmentation.SrxSplitCompare;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RomanianSRXTest {
    private static OkapiSegmenter segmenter;

    @BeforeClass
    public static void init() {
        segmenter = new OkapiSegmenter("ro");
    }

    @Test
    public void testOkapiSegmentTest() {
        this.segment();
    }

    private void segment() {
        this.test("Aceasta este o propozitie fara diacritice. ");
        this.test("Aceasta este o fraza fara diacritice.", " Propozitia a doua, tot fara diacritice. ");
        this.test("Aceasta este o propozi\u021bie cu diacritice. ");
        this.test("Aceasta este o propozi\u021bie cu diacritice.", " Propozi\u021bia a doua, cu diacritice. ");
        this.test("O propozi\u021bie!", " \u0218i \u00eenc\u0103 o propozi\u021bie. ");
        this.test("O propozi\u021bie...", "\u0218i \u00eenc\u0103 o propozi\u021bie. ");
        this.test("La adresa http://www.archeus.ro g\u0103si\u021bi resurse lingvistice. ");
        this.test("Data de 10.02.2009 nu trebuie s\u0103 fie separator de propozi\u021bii. ");
        this.test("Ast\u0103zi suntem \u00een data de 07.05.2007. ");
        this.test("Ast\u0103zi suntem \u00een data de 07/05/2007. ");
        this.test("La anum\u0103rul (1) avem pu\u021bine informa\u021bii. ");
        this.test("To jest 1. wydanie.");
        this.test("La anum\u0103rul 1. avem pu\u021bine informa\u021bii. ");
        this.test("La anum\u0103rul 13. avem pu\u021bine informa\u021bii. ");
        this.test("La anum\u0103rul 1.3.3 avem pu\u021bine informa\u021bii. ");
        this.test("O singur\u0103 propozi\u021bie... ");
        this.test("Colegii mei s-au dus... ");
        this.test("O singur\u0103 propozi\u021bie!!! ");
        this.test("O singur\u0103 propozi\u021bie??? ");
        this.test("Propozi\u021bii: una \u0219i alta. ");
        this.test("Domnu' a plecat. ");
        this.test("Profu' de istorie tre' s\u0103 predea lec\u021bia. ");
        this.test("Sal'tare! ");
        this.test("'Nea\u0163a! ");
        this.test("Deodat'apare un urs. ");
        this.test("A f\u0103cut dou\u0103 c\u00f3pii. ");
        this.test("Ionel ad\u00fan\u0103 acum ceea ce Maria adun\u00e1 \u00eenainte s\u0103 vin eu. ");
        this.test("Domnu' a plecat");
        this.test("Domnu' a plecat.", " El nu a plecat");
        this.test("Se pot \u00eent\u00e2lni \u0219i abrevieri precum S.U.A. sau B.C.R. \u00eentr-o singur\u0103 propozi\u021bie.");
        this.test("Se pot \u00eent\u00e2lni \u0219i abrevieri precum S.U.A. sau B.C.R.", " Aici sunt dou\u0103 propozi\u021bii.");
        this.test("Acela\u0219i lucru aici...", "Aici sunt dou\u0103 propozi\u021bii.");
        this.test("Acela\u0219i lucru aici... dar cu o singur\u0103 propozi\u021bie.");
        this.test("\u201eO propozi\u021bie!\u201d", " O alta.");
        this.test("\u201eO propozi\u021bie!!!\u201d", " O alta.");
        this.test("\u201eO propozi\u021bie?\u201d", " O alta.");
        this.test("\u201eO propozi\u021bie?!?\u201d", " O alta.");
        this.test("\u00abO propozi\u021bie!\u00bb", " O alta.");
        this.test("\u00abO propozi\u021bie!!!\u00bb", " O alta.");
        this.test("\u00abO propozi\u021bie?\u00bb", " O alta.");
        this.test("\u00abO propozi\u021bie???\u00bb", " O alta.");
        this.test("\u00abO propozi\u021bie?!?\u00bb", " O alta.");
        this.test("O prim\u0103 propozi\u021bie.", " (O alta.)");
        this.test("A venit domnu' Vasile. ");
        this.test("A venit domnu' acela. ");
        SrxSplitCompare.compare(new String[]{"A venit domnul", "\n\n", "Vasile."}, segmenter);
        SrxSplitCompare.compare(new String[]{"A venit domnul", "\n", "Vasile."}, segmenter);
        SrxSplitCompare.compare(new String[]{"A venit domnu'", "\n\n", "Vasile."}, segmenter);
        SrxSplitCompare.compare(new String[]{"A venit domnu'", "\n", "Vasile."}, segmenter);
        this.test("El este din Rom\u00e2nia!", "Acum e plecat cu afaceri.");
        this.test("Temperatura este de 30\u00b0C.", " Este destul de cald.");
        this.test("A alergat 50 m.", " Deja a obosit.");
        this.test("Pentru dvs. vom face o excep\u021bie.");
        this.test("Pt. dumneavoastr\u0103 vom face o excep\u021bie.");
        this.test("Pt. dvs. vom face o excep\u021bie.");
        this.test("A expus problema d.p.d.v. artistic.");
        this.test("A expus problema dpdv. artistic.");
        this.test("Are mere, pere, \u0219amd. dar nu are alune.");
        this.test("Are mere, pere, \u0219.a.m.d. dar nu are alune.");
        this.test("Are mere, pere, \u0219.a.m.d.", " \u00cen schimb, nu are alune.");
        this.test("Are mere, pere, \u015f.c.l. dar nu are alune.");
        this.test("Are mere, pere, \u015f.c.l.", " Nu are alune.");
        this.test("Are mere, pere, etc. dar nu are alune.");
        this.test("Are mere, pere, etc.", " Nu are alune.");
        this.test("Are mere, pere, \u0219.a. dar nu are alune.");
        this.test("Lec\u021bia \u00eencepe la pag. urm\u0103toare \u0219i are trei pagini.");
        this.test("Lec\u021bia \u00eencepe la pag. 20 \u0219i are trei pagini.");
        this.test("A ac\u021bionat \u00een conformitate cu lg. 144, art. 33.");
        this.test("A ac\u021bionat \u00een conformitate cu leg. 144, art. 33.");
        this.test("A ac\u021bionat \u00een conformitate cu legea nr. 11.");
        this.test("Lupta a avut loc \u00een anul 2000 \u00ee.H. \u0219i a durat trei ani.");
        this.test("Discu\u021bia a avut loc pe data de dou\u0103zeci aug. \u0219i a durat dou\u0103 ore.");
        this.test("Discu\u021bia a avut loc pe data de dou\u0103zeci ian. \u0219i a durat dou\u0103 ore.");
        this.test("Discu\u021bia a avut loc pe data de dou\u0103zeci feb. \u0219i a durat dou\u0103 ore.");
        this.test("Discu\u021bia a avut loc pe data de dou\u0103zeci ian.", " A durat dou\u0103 ore.");
        this.test("A fost \u0219i la M.Ap.N. dar nu l-au primit. ");
        this.test("A fost \u0219i la M.Ap.N.", " Nu l-au primit. ");
        this.test("Apo' da' tulai (sic!) c\u0103 mult mai e de mers.");
        this.test("Apo' da' tulai(sic!) c\u0103 mult mai e de mers.");
    }

    private void test(String ... sentences) {
        SrxSplitCompare.compare(sentences, segmenter);
    }
}

