/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.segmentation.SRXSegmenter;

public class OkapiSegmenter {
    private ISegmenter segmenter;

    public OkapiSegmenter(String srxLanguageName) {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules(SRXSegmenter.class.getClassLoader().getResourceAsStream("net/sf/okapi/lib/segmentation/defaultSegmentation.srx"));
        srxDoc.setTrimLeadingWhitespaces(false);
        srxDoc.setTrimTrailingWhitespaces(false);
        this.segmenter = srxDoc.compileLanguageRules(new LocaleId(srxLanguageName), null);
    }

    public List<String> tokenize(String text) {
        LinkedList<String> sl = new LinkedList<String>();
        TextUnit tu = new TextUnit("temp", text);
        tu.createSourceSegmentation(this.segmenter);
        for (Segment s : tu.getSource().getSegments()) {
            sl.add(s.text.getText());
        }
        return sl;
    }
}

