/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import net.sf.okapi.lib.segmentation.OkapiSegmenter;
import net.sf.okapi.lib.segmentation.SrxSplitCompare;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GermanSRXTest {
    private static OkapiSegmenter segmenter;

    @BeforeClass
    public static void init() {
        segmenter = new OkapiSegmenter("de");
    }

    @Test
    public void testOkapiSegmentTest() {
        this.segment();
    }

    private void segment() {
        this.test("Dies ist ein Satz.");
        this.test("Dies ist ein Satz.", " Noch einer.");
        this.test("Ein Satz!", " Noch einer.");
        this.test("Ein Satz...", "Noch einer.");
        this.test("Unter http://www.test.de gibt es eine Website.");
        this.test("Das Schreiben ist auf den 3.10. datiert.");
        this.test("Das Schreiben ist auf den 31.1. datiert.");
        this.test("Das Schreiben ist auf den 3.10.2000 datiert.");
        this.test("Nat\u00fcrliche Vererbungsprozesse pr\u00e4gten sich erst im 18. und fr\u00fchen 19. Jahrhundert aus.");
        this.test("Das ist ja 1a. und das auch.");
        this.test("Friedrich I., auch bekannt als Friedrich der Gro\u00dfe.");
        this.test("Friedrich II., auch bekannt als Friedrich der Gro\u00dfe.");
        this.test("Friedrich IIXC., auch bekannt als Friedrich der Gro\u00dfe.");
        this.test("Friedrich II. \u00f6fter auch bekannt als Friedrich der Gro\u00dfe.");
        this.test("Friedrich VII. \u00f6fter auch bekannt als Friedrich der Gro\u00dfe.");
        this.test("Friedrich X. \u00f6fter auch bekannt als Friedrich der Zehnte.");
        this.test("Heute ist der 13.12.2004.");
        this.test("Heute ist der 13. Dezember.");
        this.test("Heute ist der 1. Januar.");
        this.test("Es geht am 24.09. los.");
        this.test("Es geht um ca. 17:00 los.");
        this.test("Das in Punkt 3.9.1 genannte Verhalten.");
        this.test("Diese Periode begann im 13. Jahrhundert und damit bla.");
        this.test("Diese Periode begann im 13. oder 14. Jahrhundert und damit bla.");
        this.test("Diese Periode datiert auf das 13. bis zum 14. Jahrhundert und damit bla.");
        this.test("Das gilt lt. aktuellem Plan.");
        this.test("Orangen, \u00c4pfel etc. werden gekauft.");
        this.test("Das ist,, also ob es bla.");
        this.test("Das ist es..", " So geht es weiter.");
        this.test("Das hier ist ein(!) Satz.");
        this.test("Das hier ist ein(!!) Satz.");
        this.test("Das hier ist ein(?) Satz.");
        this.test("Das hier ist ein(???) Satz.");
        this.test("Das hier ist ein(???) Satz.");
        this.test("\u00bbDer Papagei ist gr\u00fcn.\u00ab", " Das kam so.");
        this.test("\u00bbDer Papagei ist gr\u00fcn\u00ab, sagte er");
        this.test("Das war es: gar nichts.");
        this.test("Das war es:", " Dies ist ein neuer Satz.");
        this.test("schlug er die Richtung nach der K \u2026 br\u00fccke ein.");
        this.test("sobald ich es von einem Freunde zur\u00fcckbekomme \u2026\u00ab Er wurde verlegen und schwieg.");
        this.test("Aus denen er sch\u00f6pfen konnte d. h. nat\u00fcrlich.");
        this.test("Er kannte eine Unmenge Quellen, aus denen er sch\u00f6pfen konnte, d. h. nat\u00fcrlich, wo er durch Arbeit sich etwas verdienen konnte.");
        this.test("Stimme am lautesten heraust\u00f6nte \u2026.", " Sobald er auf der Stra\u00dfe war");
        this.test("\u00bbWelche Wohnung?\"", " \u00bbDie, wo wir arbeiten.");
        this.test("\u00bbNun also, wie ist's?\u00ab fragte Lushin und blickte sie fest an.");
    }

    private void test(String ... sentences) {
        SrxSplitCompare.compare(sentences, segmenter);
    }
}

