/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import net.sf.okapi.lib.segmentation.OkapiSegmenter;
import net.sf.okapi.lib.segmentation.SrxSplitCompare;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EnglishSRXTest {
    private static OkapiSegmenter segmenter;

    @BeforeClass
    public static void init() {
        segmenter = new OkapiSegmenter("en");
    }

    @Test
    public void okapiSegmentTest() {
        this.segment();
    }

    @Test
    public void okapiSegmentTest2() {
        this.test("1. The first item.");
    }

    private void segment() {
        this.test("Ne. 10:17\u201319");
        this.test("Here's a");
        this.test("Here's a sentence.", " And here's one that's not comp");
        this.test("This is a sentence. ");
        this.test("This is a sentence.", " And this is another one.");
        this.test("This is a sentence.", " Isn't it?", " Yes, it is.");
        this.test("This is e.g. Mr. Smith, who talks slowly...", "But this is another sentence.");
        this.test("Chanel no. 5 is blah.");
        this.test("Mrs. Jones gave Peter $4.5, to buy Chanel No 5.", " He never came back.");
        this.test("On p. 6 there's nothing.", " Another sentence.");
        this.test("Leave me alone!, he yelled.", " Another sentence.");
        this.test("\"Leave me alone!\", he yelled.");
        this.test("'Leave me alone!', he yelled.", " Another sentence.");
        this.test("'Leave me alone!,' he yelled.", " Another sentence.");
        this.test("This works on the phrase level, i.e. not on the word level.");
        this.test("Let's meet at 5 p.m. in the main street.");
        this.test("James comes from the U.K. where he worked as a programmer.");
        this.test("Don't split strings like U.S.A. please.");
        this.test("Don't split strings like U. S. A. either.");
        this.test("Don't split...", "Well you know.", " Here comes more text.");
        this.test("Don't split... well you know.", " Here comes more text.");
        this.test("The \".\" should not be a delimiter in quotes.");
        this.test("\"Here he comes!\", she said.");
        this.test("\"Here he comes.\"", " But this is another sentence.");
        this.test("\"Here he comes!\".", " That's what he said.");
        this.test("The sentence ends here.", " (Another sentence.)");
        this.test("The sentence (...) ends here.");
        this.test("The sentence [...] ends here.");
        this.test("The sentence ends here (...).", " Another sentence.");
        this.test("He won't.", " Really.");
        this.test("He will not.", " Really.");
        this.test("He won't go.", " Really.");
        this.test("He won't say no. 5 is better.", " Not really.");
        this.test("He won't say No. 5 is better.", " Not really.");
        this.test("He won't say no.", " Not really.");
        this.test("He won't say No.", " Not really.");
        this.test("They met at 5 p.m. on Thursday.");
        this.test("They met at 5 p.m.", " It was Thursday.");
        this.test("This is it: a test.");
        this.test("12) Make sure that the lamp is on.", " 12) Make sure that the lamp is on. ");
        this.test("He also offers a conversion table (see Cohen, 1988, p. 123). ");
        this.test("He won't", "\n\n", "Really.");
        this.test("He won't", "\n", "Really.");
        this.test("He won't", "\n", "Really.");
        this.test("James is from the Ireland!", " He lives in Spain now.");
        this.test("Jones Bros. have built a successful company.");
        this.test("It (really!) works.");
        this.test("It [really!] works.");
        this.test("It works (really!).", " No doubt.");
        this.test("It works [really!].", " No doubt.");
        this.test("It really(!) works well.");
        this.test("It really[!] works well.");
        this.test("Translation:", " Rock-bottom prices for local growers.", " \"You're going to lose farmers to bankruptcy; there's no way else to say it,\" says Turp Garrett, the agricultural extension agent for Worcester County, Md.\"", " It's not very pretty.\"");
        this.test("My name is Jonas E. Smith.");
        this.test("Please turn to p. 55.");
        this.test("Were Jane and co. at the party?");
        this.test("They closed the deal with Pitt, Briggs & Co. at noon.");
        this.test("Let's ask Jane and co.", " They should know.");
        this.test("They closed the deal with Pitt, Briggs & Co.", " It closed yesterday.");
        this.test("I can see Mt. Fuji from here.");
        this.test("St. Michael's Church is on 5th st. near the light.");
        this.test("That is JFK Jr.'s book.");
        this.test("I visited the U.S.A. last year.");
        this.test("I live in the E.U.", " How about you?");
        this.test("I live in the U.S.", " How about you?");
        this.test("I have lived in the U.S. for 20 years.");
        this.test("At 5 a.m. Mr. Smith went to the bank.", " He left the bank at 6 P.M.", " They then went to the store.");
        this.test("She has $100.00.", " It is in her bag.");
        this.test("He teaches science (He previously worked for 5 years as an engineer.) at the local University.");
        this.test("Her email is Jane.Doe@example.com.", " I sent her an email.");
        this.test("The site is: https://www.example.50.com/new-site/awesome_content.html.", " Please check it out.");
        this.test("She turned to him, 'This is great.' she said.");
        this.test("She turned to him, \"This is great.\" she said.");
        this.test("She turned to him, \"This is great.\"", " She held the book out to show him.");
        this.test("Hello!!", " Long time no see.");
        this.test("Hello??", " Who is there?");
        this.test("Hello!?", " Is that you?");
        this.test("Hello?!", " Is that you?");
        this.test("You can find it at N\u00b0. 1026.253.553.", " That is where the treasure is.");
        this.test("She works at Yahoo! in the accounting department.");
        this.test("The nurse gave him the i.v. in his vein.", " She gave him the i.v.", " It was a great I.V. that she gave him.", " She gave him the I.V.", " It was night.");
        this.test("Leave me alone!", " He yelled.", " I am in the U.S. Army.", " Charles (Ind.) said he.");
        this.test("The GmbH & Co. KG is a limited partnership with, typically, the sole general partner being a limited liability company.");
        this.test("\"It's a good thing that the water is really calm,\" I answered ironically.");
        this.test("December 31, 1988.", " Hello world.", " It's great!", " Born April 05, 1989.");
        this.test("[A sentence in square brackets.]");
        this.test("This abbreviation f.e. means for example.");
        this.test("The med. staff here is very kind.");
        this.test("What did you order btw., she wondered.");
        this.test("This is the U.S. Senate my friends.", " Yes.", " It is!");
        this.test("SEC. 1262 AUTHORIZATION OF APPROPRIATIONS.");
        this.test("Hello.", " 'This is a test of single quotes.'", " A new sentence.");
        this.test("1.) The first item.", " 2.) The second item.");
        this.test("1) The first item.", " 2) The second item.");
        this.test("1.) The first item 2.) The second item");
        this.test("1) The first item 2) The second item");
        this.test("1. The first item.");
        this.test("a. The first item.");
        this.test("https://www.example.com/foo/?bar=baz&inga=42&quux");
        this.test("[A sentence in square brackets.]");
        this.test("Hello.", " 'This is a test of single quotes.'", " A new sentence.");
        this.test("\"Dinah'll miss me very much to-night, I should think!\"", " (Dinah was the cat.)");
        this.test("The nurse gave him the i.v. in his vein.", " She gave him the i.v.", " It was a great I.V. that she gave him.", " She gave him the I.V.", " It was night.");
        this.test("On Jan. 20, former Sen. Barack Obama became the 44th President of the U.S.", " Millions attended the Inauguration.");
        this.test("He works for ABC Ltd. and sometimes for BCD Ltd.", " She works for ABC Co. and BCD Co.", " They work for ABC Corp. and BCD Corp.");
        this.test("Rolls-Royce Motor Cars Inc. said it expects its U.S. sales to remain steady at about 1,200 cars in 1990.", " 'So what if you miss 50 tanks somewhere?'", " asks Rep. Norman Dicks (D. Wash.), a member of the House group that visited the talks in Vienna.");
    }

    private void test(String ... sentences) {
        SrxSplitCompare.compare(sentences, segmenter);
    }
}

