/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import net.sf.okapi.lib.segmentation.OkapiSegmenter;
import net.sf.okapi.lib.segmentation.SrxSplitCompare;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DutchSRXTest {
    private static OkapiSegmenter segmenter;

    @BeforeClass
    public static void init() {
        segmenter = new OkapiSegmenter("nl");
    }

    @Test
    public void testOkapiSegmentTest() {
        this.segment();
    }

    private void segment() {
        this.test("Dit is een zin.");
        this.test("Dit is een zin.", " Nog een.");
        this.test("Een zin!", " Nog een.");
        this.test("Een zin... ", "Nog een.");
        this.test("Op http://www.test.de vind je een website.");
        this.test("De brief is op 3.10 gedateerd.");
        this.test("De brief is op 31.1 gedateerd.");
        this.test("De breif is op 3.10.2000 gedateerd.");
        this.test("Vandaag is het 13.12.2004.");
        this.test("Op 24.09 begint het.");
        this.test("Om 17:00 begint het.");
        this.test("In paragraaf 3.9.1 is dat beschreven.");
        this.test("Januari jl. is dat vastgelegd.");
        this.test("Appel en pruimen enz. werden gekocht.");
        this.test("De afkorting n.v.t. betekent niet van toepassing.");
        this.test("Bla et al. blah blah.");
        this.test("Dat is,, of het is bla.");
        this.test("Dat is het..", " Zo gaat het verder.");
        this.test("Dit hier is een(!) zin.");
        this.test("Dit hier is een(!!) zin.");
        this.test("Dit hier is een(?) zin.");
        this.test("Dit hier is een(???) zin.");
        this.test("Dit hier is een(???) zin.");
        this.test("\u00bbDe papagaai is groen.\u00ab", " Dat was hij al.");
        this.test("\u00bbDe papagaai is groen\u00ab, zei hij.");
        this.test("Als voetballer wordt hij nooit een prof.", " Maar prof. N.A.W. Th.Ch. Janssen wordt dat wel.");
        this.test("Dat was het: helemaal niets.");
        this.test("Dat was het: het is een nieuwe zin.");
    }

    private void test(String ... sentences) {
        SrxSplitCompare.compare(sentences, segmenter);
    }
}

