/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.plaintext.PlainTextFilter;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SRXDocumentTest {
    private FileLocation location = FileLocation.fromClass(SRXDocumentTest.class);

    @Before
    public void setUp() {
    }

    @Test
    public void testGetSet() {
        SRXDocument doc = new SRXDocument();
        Assert.assertFalse((boolean)doc.cascade());
        Assert.assertFalse((boolean)doc.includeStartCodes());
        Assert.assertTrue((boolean)doc.includeEndCodes());
        Assert.assertFalse((boolean)doc.includeIsolatedCodes());
        Assert.assertTrue((boolean)doc.segmentSubFlows());
        Assert.assertFalse((boolean)doc.oneSegmentIncludesAll());
        Assert.assertFalse((boolean)doc.trimLeadingWhitespaces());
        Assert.assertFalse((boolean)doc.trimTrailingWhitespaces());
        Assert.assertFalse((boolean)doc.treatIsolatedCodesAsWhitespace());
        doc.setCascade(true);
        Assert.assertTrue((boolean)doc.cascade());
        doc.setIncludeStartCodes(true);
        Assert.assertTrue((boolean)doc.includeStartCodes());
        doc.setIncludeEndCodes(false);
        Assert.assertFalse((boolean)doc.includeEndCodes());
        doc.setIncludeIsolatedCodes(true);
        Assert.assertTrue((boolean)doc.includeIsolatedCodes());
        doc.setSegmentSubFlows(false);
        Assert.assertFalse((boolean)doc.segmentSubFlows());
        doc.setOneSegmentIncludesAll(true);
        Assert.assertTrue((boolean)doc.oneSegmentIncludesAll());
        doc.setTrimLeadingWhitespaces(true);
        Assert.assertTrue((boolean)doc.trimLeadingWhitespaces());
        doc.setTrimTrailingWhitespaces(true);
        Assert.assertTrue((boolean)doc.trimTrailingWhitespaces());
        doc.setTreatIsolatedCodesAsWhitespace(true);
        Assert.assertTrue((boolean)doc.treatIsolatedCodesAsWhitespace());
    }

    @Test
    public void testObjects() {
        Rule rule = new Rule();
        Assert.assertEquals((Object)"", (Object)rule.getBefore());
        Assert.assertEquals((Object)"", (Object)rule.getAfter());
        Assert.assertTrue((boolean)rule.isBreak());
        Assert.assertTrue((boolean)rule.isActive());
        String tmp = "regex";
        rule.setAfter(tmp);
        Assert.assertEquals((Object)rule.getAfter(), (Object)tmp);
        rule.setBefore(tmp);
        Assert.assertEquals((Object)rule.getBefore(), (Object)tmp);
        rule.setBreak(false);
        Assert.assertFalse((boolean)rule.isBreak());
        rule.setActive(false);
        Assert.assertFalse((boolean)rule.isActive());
        String pattern = "pattern";
        String ruleName = "ruleName";
        LanguageMap lm = new LanguageMap(pattern, ruleName);
        Assert.assertEquals((Object)lm.getPattern(), (Object)pattern);
        Assert.assertEquals((Object)lm.getRuleName(), (Object)ruleName);
    }

    @Test
    public void testRules() {
        SRXDocument doc = new SRXDocument();
        doc.setCascade(true);
        ArrayList<Rule> list = new ArrayList<Rule>();
        list.add(new Rule("Mr\\.", "\\s", false));
        doc.addLanguageRule("english", list);
        ArrayList rules = doc.getLanguageRules("english");
        Assert.assertEquals((long)1L, (long)rules.size());
        list = new ArrayList();
        list.add(new Rule("\\.+", "\\s", true));
        doc.addLanguageRule("default", list);
        doc.addLanguageMap(new LanguageMap("en.*", "english"));
        doc.addLanguageMap(new LanguageMap(".*", "default"));
        SRXSegmenter seg = (SRXSegmenter)doc.compileLanguageRules(LocaleId.fromString((String)"en"), null);
        Assert.assertNotNull((Object)seg);
        Assert.assertTrue((boolean)seg.getLanguage().equalToString("en"));
        Assert.assertNull((Object)seg.getRanges());
        seg.computeSegments("Mr. Holmes. The detective.");
        Assert.assertNotNull((Object)seg.getRanges());
        Assert.assertEquals((long)2L, (long)seg.getRanges().size());
        seg.computeSegments("MR. Holmes. The detective.");
        Assert.assertEquals((long)3L, (long)seg.getRanges().size());
        TextFragment tf = new TextFragment("One.");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" Two.");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        TextContainer tc = new TextContainer(tf);
        seg.setOptions(true, true, true, false, false, false, false, true, false, false);
        seg.computeSegments(tc);
        List ranges = seg.getRanges();
        Assert.assertNotNull((Object)ranges);
        Assert.assertEquals((long)2L, (long)ranges.size());
        Assert.assertEquals((long)6L, (long)((Range)ranges.get((int)0)).end);
        Assert.assertEquals((long)6L, (long)((Range)ranges.get((int)1)).start);
        seg.setOptions(true, false, true, false, false, false, false, true, false, false);
        seg.computeSegments(tc);
        ranges = seg.getRanges();
        Assert.assertNotNull((Object)ranges);
        Assert.assertEquals((long)2L, (long)ranges.size());
        Assert.assertEquals((long)4L, (long)((Range)ranges.get((int)0)).end);
        Assert.assertEquals((long)4L, (long)((Range)ranges.get((int)1)).start);
    }

    @Test
    public void testComments() {
        SRXDocument doc = this.createDocument();
        Assert.assertNotNull((Object)doc.getComments());
        Assert.assertEquals((Object)"Main comment", (Object)doc.getComments());
        Assert.assertNotNull((Object)doc.getHeaderComments());
        Assert.assertEquals((Object)"Header comment", (Object)doc.getHeaderComments());
        LinkedHashMap list = doc.getAllLanguageRules();
        Assert.assertNotNull((Object)list);
        ArrayList rules = (ArrayList)list.get("default");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertNotNull((Object)((Rule)rules.get(0)).getComment());
        Assert.assertEquals((Object)"Rule comment", (Object)((Rule)rules.get(0)).getComment());
    }

    @Test
    public void testSimpleRule() {
        SRXDocument doc = this.createDocument();
        LinkedHashMap list = doc.getAllLanguageRules();
        Assert.assertNotNull((Object)list);
        ArrayList rules = (ArrayList)list.get("default");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"([A-Z]\\.){2,}", (Object)((Rule)rules.get(0)).getBefore());
        Assert.assertEquals((Object)"\\s", (Object)((Rule)rules.get(0)).getAfter());
        Assert.assertFalse((boolean)((Rule)rules.get(0)).isBreak());
    }

    @Test
    public void testLoadRulesFromStream() {
        SRXDocument doc = this.createDocument();
        doc.loadRules(this.location.in("Test02.srx").asInputStream());
        LinkedHashMap list = doc.getAllLanguageRules();
        Assert.assertNotNull((Object)list);
        ArrayList rules = (ArrayList)list.get("default");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
    }

    @Test
    public void testLoadRulesFromPath() {
        SRXDocument doc = this.createDocument();
        doc.loadRules(this.location.in("/Test01.srx").toString());
        LinkedHashMap list = doc.getAllLanguageRules();
        Assert.assertNotNull((Object)list);
        ArrayList rules = (ArrayList)list.get("default");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTradosCompatibility() throws IOException {
        String testFile = "TradosTest";
        GenericContent fmt = new GenericContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.location.in("/" + testFile + ".tmx.txt").asInputStream(), StandardCharsets.UTF_8));
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules(this.location.in("/tradosSegmentation.srx").toString());
        ISegmenter segmenter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        RawDocument rd = new RawDocument(this.location.in("/" + testFile + ".html").asUri(), "UTF-8", LocaleId.ENGLISH);
        HtmlFilter filter = new HtmlFilter();
        try {
            filter.open(rd);
            while (filter.hasNext()) {
                Event event = filter.next();
                if (!event.isTextUnit()) continue;
                ITextUnit tu = event.getTextUnit();
                TextContainer tc = tu.getSource();
                segmenter.computeSegments(tc);
                tc.getSegments().create(segmenter.getRanges());
                for (Segment seg : tc.getSegments()) {
                    TextFragment tf = seg.getContent();
                    tf.renumberCodes(1);
                    String okapiText = fmt.setContent(tf).toString();
                    String goldText = reader.readLine();
                    Assert.assertEquals((Object)goldText, (Object)okapiText);
                }
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testChinese() throws IOException {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules(this.location.in("/defaultSegmentation.srx").toString());
        ISegmenter segmenter = srxDoc.compileLanguageRules(LocaleId.ENGLISH, null);
        try (PlainTextFilter filter = new PlainTextFilter();
             RawDocument rd = new RawDocument(this.location.in("/chinese.txt").asUri(), "UTF-16LE", LocaleId.CHINA_CHINESE);){
            filter.open(rd);
            while (filter.hasNext()) {
                Event event = filter.next();
                if (!event.isTextUnit()) continue;
                ITextUnit tu = event.getTextUnit();
                TextContainer tc = tu.getSource();
                segmenter.computeSegments(tc);
                tc.getSegments().create(segmenter.getRanges());
                for (Segment seg : tc.getSegments()) {
                    TextFragment tf = seg.getContent();
                    tf.renumberCodes(1);
                }
            }
        }
    }

    @Test
    public void testLoadIsolatedCodeRules() {
        SRXDocument doc = this.createDocument();
        doc.loadRules(this.location.in("/isolated_code.srx").asInputStream());
        LinkedHashMap list = doc.getAllLanguageRules();
        Assert.assertNotNull((Object)list);
        ArrayList rules = (ArrayList)list.get("default");
        Assert.assertNotNull((Object)rules);
        SRXSegmenter seg = (SRXSegmenter)doc.compileLanguageRules(LocaleId.fromString((String)"en"), null);
        TextFragment tf = new TextFragment("One.");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append("Two.");
        TextContainer tc = new TextContainer(tf);
        ISegments segments = tc.getSegments();
        int n = seg.computeSegments(tc);
        Assert.assertEquals((long)2L, (long)n);
        segments.create(seg.getRanges());
        Assert.assertEquals((long)2L, (long)segments.count());
        Assert.assertEquals((Object)"One.", (Object)segments.get(0).toString());
        Assert.assertEquals((Object)"<x/>Two.", (Object)segments.get(1).toString());
    }

    private SRXDocument createDocument() {
        SRXDocument doc = new SRXDocument();
        String srx = "<!--Main comment--><srx xmlns='http://www.lisa.org/srx20' version='2.0'><!--Header comment--><header segmentsubflows='yes' cascade='no'><formathandle type='start' include='no'/><formathandle type='end' include='yes'/><formathandle type='isolated' include='no'/></header><body><languagerules><languagerule languagerulename='default'><!--Rule comment--><rule break='no'><beforebreak>([A-Z]\\.){2,}</beforebreak><afterbreak>\\s</afterbreak></rule></languagerule></languagerules><maprules><languagemap languagepattern='.*' languagerulename='default'/></maprules></body></srx>";
        doc.loadRules((CharSequence)srx);
        return doc;
    }

    @Test(expected=OkapiException.class)
    public void testInvalidSegmentationFile() {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules("ThisDoesNotExist");
    }

    @Test
    public void testDefaultSegmentationRules() {
        SRXDocument srxDoc = new SRXDocument();
        srxDoc.loadRules("DEFAULT_SRX_RULES");
    }
}

