/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.scorer;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.search.lucene.analysis.AlphabeticNgramTokenizer;

public class Util {
    public static float calculateDiceCoefficient(int intersection, int size1, int size2) {
        return 2.0f * (float)intersection / (float)(size1 + size2) * 100.0f;
    }

    public static float calculateNgramDiceCoefficient(String originalSource, String newSource, AlphabeticNgramTokenizer tokenizer) {
        HashSet<String> originalSourceTokens = new HashSet<String>();
        HashSet<String> newSourceTokens = new HashSet<String>();
        try {
            tokenizer.reset(new StringReader(originalSource));
            while (tokenizer.incrementToken()) {
                originalSourceTokens.add(tokenizer.getTermAttribute().toString());
            }
            tokenizer.reset(new StringReader(newSource));
            while (tokenizer.incrementToken()) {
                newSourceTokens.add(tokenizer.getTermAttribute().toString());
            }
        }
        catch (IOException e) {
            throw new OkapiException("Error tokenizing source TextUnits", (Throwable)e);
        }
        int originalSize = originalSourceTokens.size();
        int newSize = newSourceTokens.size();
        originalSourceTokens.retainAll(newSourceTokens);
        int intersection = originalSourceTokens.size();
        return 2.0f * (float)intersection / (float)(originalSize + newSize) * 100.0f;
    }

    public static AlphabeticNgramTokenizer createNgramTokenizer(int ngramSize, LocaleId localeId) {
        return new AlphabeticNgramTokenizer(new StringReader(""), ngramSize, localeId.toJavaLocale());
    }
}

