/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.lib.search.lucene.scorer.TmFuzzyScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class TmFuzzyQuery
extends Query {
    float threshold;
    List<Term> terms;
    String termCountField;

    public TmFuzzyQuery(float threshold, String termCountField) {
        this.threshold = threshold;
        this.terms = new ArrayList<Term>();
        this.termCountField = termCountField;
    }

    public void add(Term term) {
        this.terms.add(term);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new TmFuzzyWeight(searcher);
    }

    public void extractTerms(Set<Term> terms) {
        terms.addAll(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public String toString(String field) {
        return this.terms.toString();
    }

    protected class TmFuzzyWeight
    extends Weight {
        Similarity similarity;

        public TmFuzzyWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(this.getValue(), ((Object)((Object)this)).toString());
        }

        public Query getQuery() {
            return TmFuzzyQuery.this;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (TmFuzzyQuery.this.terms.size() == 0) {
                return null;
            }
            return new TmFuzzyScorer(TmFuzzyQuery.this.threshold, this.similarity, TmFuzzyQuery.this.terms, reader, TmFuzzyQuery.this.termCountField);
        }

        public float getValue() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }
    }
}

