/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.lib.search.lucene.scorer.SimpleConcordanceFuzzyScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class SimpleConcordanceFuzzyQuery
extends Query {
    float threshold;
    List<Term> terms;

    public SimpleConcordanceFuzzyQuery(float threshold) {
        this.threshold = threshold;
        this.terms = new LinkedList<Term>();
    }

    public void add(Term term) {
        this.terms.add(term);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new SimpleConcordanceFuzzyWeight(searcher);
    }

    public void extractTerms(Set terms) {
        terms.add(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public String toString(String field) {
        return this.terms.toString();
    }

    protected class SimpleConcordanceFuzzyWeight
    extends Weight {
        Similarity similarity;

        public SimpleConcordanceFuzzyWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(this.getValue(), ((Object)((Object)this)).toString());
        }

        public Query getQuery() {
            return SimpleConcordanceFuzzyQuery.this;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (SimpleConcordanceFuzzyQuery.this.terms.size() == 0) {
                return null;
            }
            return new SimpleConcordanceFuzzyScorer(SimpleConcordanceFuzzyQuery.this.threshold, this.similarity, SimpleConcordanceFuzzyQuery.this.terms, reader);
        }

        public float getValue() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }
    }
}

