/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.search.lucene.scorer.ConcordanceFuzzyScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class ConcordanceFuzzyQuery
extends Query {
    private String field;
    float threshold;
    private List<Term> terms = new ArrayList<Term>();
    private int slop = 0;

    public ConcordanceFuzzyQuery(float threshold) {
        this.threshold = threshold;
    }

    public void setSlop(int slop) {
        this.slop = slop;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.add(term);
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new ConcordanceFuzzyWeight(searcher);
    }

    public String toString(String field) {
        return this.terms.toString();
    }

    protected class ConcordanceFuzzyWeight
    extends Weight {
        Similarity similarity;

        public ConcordanceFuzzyWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(this.getValue(), ((Object)((Object)this)).toString());
        }

        public Query getQuery() {
            return ConcordanceFuzzyQuery.this;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (ConcordanceFuzzyQuery.this.terms.size() == 0) {
                return null;
            }
            Term[] termArray = new Term[ConcordanceFuzzyQuery.this.terms.size()];
            termArray = ConcordanceFuzzyQuery.this.terms.toArray(termArray);
            TermPositions[] termPositions = new TermPositions[ConcordanceFuzzyQuery.this.terms.size()];
            for (int i = 0; i < termArray.length; ++i) {
                TermPositions p = reader.termPositions(termArray[i]);
                if (p == null) {
                    return null;
                }
                termPositions[i] = p;
            }
            MultipleTermPositions multipleTermPositions = new MultipleTermPositions(reader, termArray);
            return new ConcordanceFuzzyScorer(ConcordanceFuzzyQuery.this.threshold, this.similarity, ConcordanceFuzzyQuery.this.terms, termPositions, multipleTermPositions, reader);
        }

        public float getValue() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }
    }
}

