/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.reporting;

import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.Util;
import net.sf.okapi.lib.reporting.ReportGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReportGeneratorTest {
    private FileLocation root;

    @Before
    public void setUp() throws Exception {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void reportTest() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_report.txt").asInputStream());
        gen.setField("A1", "<a1>");
        gen.setField("A2", "<a2>");
        gen.setField("A3", "<a3>");
        gen.setField("A4", "<a4>");
        gen.setField("A5", "<a5>");
        gen.setField("A6", "<a6>");
        String report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
        report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
    }

    @Test
    public void tableReportTest() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report.txt").asInputStream());
        gen.setField("A1", "<a1>");
        gen.setField("A2", "<a2>");
        gen.setField("A3", "<a3>");
        gen.setField("A4", "<a4>");
        gen.setField("A5", "<a5>");
        gen.setField("A6", "<a6>");
        gen.setField("A7", "<a7.1>");
        gen.setField("A8", "<a8.1>");
        gen.setField("A9", "<a9.1>");
        gen.setField("A10", "<a10.1>");
        gen.setField("A7", "<a7.2>");
        gen.setField("A8", "<a8.2>");
        gen.setField("A9", "<a9.2>");
        gen.setField("A10", "<a10.2>");
        gen.setField("A7", "<a7.3>");
        gen.setField("A8", "<a8.3>");
        gen.setField("A9", "<a9.3>");
        gen.setField("A10", "<a10.3>");
        gen.setField("A7", "<a7.4>");
        gen.setField("A8", "<a8.4>");
        gen.setField("A9", "<a9.4>");
        gen.setField("A10", "<a10.4>");
        gen.setField("A7", "<a7.5>");
        gen.setField("A8", "<a8.5>");
        gen.setField("A9", "<a9.5>");
        gen.setField("A10", "<a10.5>");
        String report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n<a7.1>,<a8.1>,<a9.1>,<a10.1>,\n<a7.2>,<a8.2>,<a9.2>,<a10.2>,\n<a7.3>,<a8.3>,<a9.3>,<a10.3>,\n<a7.4>,<a8.4>,<a9.4>,<a10.4>,\n<a7.5>,<a8.5>,<a9.5>,<a10.5>,\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
        report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n<a7.1>,<a8.1>,<a9.1>,<a10.1>,\n<a7.2>,<a8.2>,<a9.2>,<a10.2>,\n<a7.3>,<a8.3>,<a9.3>,<a10.3>,\n<a7.4>,<a8.4>,<a9.4>,<a10.4>,\n<a7.5>,<a8.5>,<a9.5>,<a10.5>,\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
    }

    @Test
    public void tableReportTest2() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report2.txt").asInputStream());
        gen.setField("A1", "<a1>");
        gen.setField("A2", "<a2>");
        gen.setField("A3", "<a3>");
        gen.setField("A4", "<a4>");
        gen.setField("A5", "<a5>");
        gen.setField("A6", "<a6>");
        gen.setField("A7", "<a7.1>");
        gen.setField("A8", "<a8.1>");
        gen.setField("A9", "<a9.1>");
        gen.setField("A10", "<a10.1>");
        gen.setField("A7", "<a7.2>");
        gen.setField("A8", "<a8.2>");
        gen.setField("A9", "<a9.2>");
        gen.setField("A10", "<a10.2>");
        gen.setField("A7", "<a7.3>");
        gen.setField("A8", "<a8.3>");
        gen.setField("A9", "<a9.3>");
        gen.setField("A10", "<a10.3>");
        gen.setField("A7", "<a7.4>");
        gen.setField("A8", "<a8.4>");
        gen.setField("A9", "<a9.4>");
        gen.setField("A10", "<a10.4>");
        gen.setField("A7", "<a7.5>");
        gen.setField("A8", "<a8.5>");
        gen.setField("A9", "<a9.5>");
        gen.setField("A10", "<a10.5>");
        String report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n<a7.1>\n<a7.2>\n<a7.3>\n<a7.4>\n<a7.5>\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
    }

    @Test
    public void tableReportTest3() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report2.txt").asInputStream());
        gen.setField("A1", "<a1>");
        gen.setField("A2", "<a2>");
        gen.setField("A3", "<a3>");
        gen.setField("A4", "<a4>");
        gen.setField("A5", "<a5>");
        gen.setField("A7", "<a7.1>");
        gen.setField("A8", "<a8.1>");
        gen.setField("A9", "<a9.1>");
        gen.setField("A10", "<a10.1>");
        gen.setField("A7", "<a7.2>");
        gen.setField("A8", "<a8.2>");
        gen.setField("A9", "<a9.2>");
        gen.setField("A10", "<a10.2>");
        gen.setField("A7", "<a7.3>");
        gen.setField("A8", "<a8.3>");
        gen.setField("A9", "<a9.3>");
        gen.setField("A10", "<a10.3>");
        gen.setField("A7", "<a7.4>");
        gen.setField("A8", "<a8.4>");
        gen.setField("A9", "<a9.4>");
        gen.setField("A10", "<a10.4>");
        gen.setField("A7", "<a7.5>");
        gen.setField("A8", "<a8.5>");
        gen.setField("A9", "<a9.5>");
        gen.setField("A10", "<a10.5>");
        String report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n<a7.1>\n<a7.2>\n<a7.3>\n<a7.4>\n<a7.5>\n\nTotal,<a4>,<a5>,[?A6]\n\nThe report was created on <a1>\n", (Object)report);
    }

    @Test
    public void tableReportTest4() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report2.txt").asInputStream());
        gen.setField("A1", "<a1>");
        gen.setField("A2", "<a2>");
        gen.setField("A3", "<a3>");
        gen.setField("A4", "<a4>");
        gen.setField("A5", "<a5>");
        gen.setField("A6", "<a6>");
        String report = Util.normalizeNewlines((String)gen.generate());
        Assert.assertEquals((Object)"Test report\n\n#Creation Date: <a1>\n#Project Name: <a2>\n#Target Locale: <a3>\n\n{?[?A7]}\n\nTotal,<a4>,<a5>,<a6>\n\nThe report was created on <a1>\n", (Object)report);
    }

    @Test
    public void tableReportTest5() {
        ReportGenerator gen = new ReportGenerator(this.root.in("scoping_report.html").asInputStream());
        Assert.assertTrue((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
    }

    @Test
    public void tableReportTest6() {
        ReportGenerator gen = new ReportGenerator(this.root.in("scoping_report2.html").asInputStream());
        Assert.assertTrue((boolean)gen.isHtmlReport());
        Assert.assertFalse((boolean)gen.isMultiItemReport());
    }

    @Test
    public void tableReportTest7() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report3.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
    }

    @Test
    public void tableReportTest8() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_table_report4.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertFalse((boolean)gen.isMultiItemReport());
    }

    @Test
    public void tableReportTest9() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template1.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT", "import1");
        gen.setField("IMPORT", "import2");
        gen.setField("IMPORT", "import3");
        Assert.assertEquals((Object)"import1;\nimport2;\nimport3;", (Object)Util.normalizeNewlines((String)gen.generate()));
    }

    @Test
    public void tableReportTest10() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template2.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT", "import1");
        gen.setField("IMPORT", "import2");
        gen.setField("IMPORT", "import3");
        Assert.assertEquals((Object)"   import import1;\n   import import2;\n   import import3;", (Object)Util.normalizeNewlines((String)gen.generate()));
    }

    @Test
    public void tableReportTest11() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template3.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT", "import1");
        gen.setField("IMPORT", "import2");
        gen.setField("IMPORT", "import3");
        gen.setField("IMPORT_DESCR", "description 1");
        gen.setField("IMPORT_DESCR", "description 2");
        gen.setField("IMPORT_DESCR", "description 3");
        Assert.assertEquals((Object)"   import import1; // description 1\n   import import2; // description 2\n   import import3; // description 3", (Object)Util.normalizeNewlines((String)gen.generate()));
    }

    @Test
    public void tableReportTest11_missing_field_value() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template3.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT", "import1");
        gen.setField("IMPORT", "import2");
        gen.setField("IMPORT", "import3");
        Assert.assertEquals((Object)"   import import1; // [?IMPORT_DESCR]\n   import import2; // [?IMPORT_DESCR]\n   import import3; // [?IMPORT_DESCR]", (Object)Util.normalizeNewlines((String)gen.generate()));
    }

    @Test
    public void tableReportTest11_missing_field_value2() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template3.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT_DESCR", "description 1");
        gen.setField("IMPORT_DESCR", "description 2");
        gen.setField("IMPORT_DESCR", "description 3");
        Assert.assertEquals((Object)"   import [?IMPORT]; // description 1\n   import [?IMPORT]; // description 2\n   import [?IMPORT]; // description 3", (Object)Util.normalizeNewlines((String)gen.generate()));
    }

    @Test
    public void tableReportTest12() {
        ReportGenerator gen = new ReportGenerator(this.root.in("test_template4.txt").asInputStream());
        Assert.assertFalse((boolean)gen.isHtmlReport());
        Assert.assertTrue((boolean)gen.isMultiItemReport());
        gen.setField("IMPORT", "import1");
        gen.setField("IMPORT", "import2");
        gen.setField("IMPORT", "import3");
        gen.setField("IMPORT_DESCR", "description 1");
        gen.setField("IMPORT_DESCR", "description 2");
        gen.setField("IMPORT_DESCR", "description 3");
        Assert.assertEquals((Object)"     line 1\n  line 2\n   import import1; // description 1\n   import import2; // description 2\n   import import3; // description 3", (Object)Util.normalizeNewlines((String)gen.generate()));
    }
}

