/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.simplification;

import java.util.ArrayList;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.lib.preprocessing.filters.simplification.Parameters;
import net.sf.okapi.lib.preprocessing.filters.simplification.SimplificationFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestDoubleExtraction_XML {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private FileLocation root;

    @Before
    public void startUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testDoubleExtraction_XML() {
        SimplificationFilter filter = new SimplificationFilter();
        Parameters params = filter.getParameters();
        params.setSimplifyResources(true);
        params.setSimplifyCodes(false);
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.root.in("/about.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/failure.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/PI-Problem.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/simple_cdata.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/subfilter-simple.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/success.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_drive.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_href_reference.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/translate-attr-subfilter.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/xml-freemarker.xml").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)filter, list, "UTF-8", ENUS, ENUS, "out"));
    }

    @Test
    public void testDoubleExtraction_DefaultConfig() {
        SimplificationFilter filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification");
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.root.in("/about.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/failure.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/PI-Problem.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/simple_cdata.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/subfilter-simple.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/success.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_drive.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_href_reference.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/translate-attr-subfilter.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/xml-freemarker.xml").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)filter, list, "UTF-8", ENUS, ENUS, "out"));
    }

    @Test
    public void testDoubleExtraction_ResourcesConfig() {
        SimplificationFilter filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification-xmlResources");
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.root.in("/about.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/failure.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/PI-Problem.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/simple_cdata.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/subfilter-simple.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/success.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_drive.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_href_reference.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/translate-attr-subfilter.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/xml-freemarker.xml").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)filter, list, "UTF-8", ENUS, ENUS, "out"));
    }

    @Test
    public void testDoubleExtraction_CodesConfig() {
        SimplificationFilter filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification-xmlCodes");
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.root.in("/about.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/failure.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/PI-Problem.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/simple_cdata.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/subfilter-simple.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/success.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_drive.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/test_href_reference.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/translate-attr-subfilter.xml").toString(), null));
        list.add(new InputDocument(this.root.in("/xml-freemarker.xml").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)filter, list, "UTF-8", ENUS, ENUS, "out"));
    }
}

