/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.common;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.steps.EventListBuilderStep;
import net.sf.okapi.lib.extra.steps.TuDpLogger;
import net.sf.okapi.lib.preprocessing.filters.common.PreprocessingFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.ResourceSimplifierStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestFilterEvents {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private FileLocation root;

    @Before
    public void startUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void listInternalFilterEvents() {
        HtmlFilter filter = new HtmlFilter();
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("/form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)filter), new TuDpLogger()}).execute();
    }

    @Test
    public void listTransformedEvents() {
        PreprocessingFilter filter = new PreprocessingFilter((IFilter)new HtmlFilter(), new IPipelineStep[]{new ResourceSimplifierStep()});
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("/form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)filter), new TuDpLogger()}).execute();
    }

    @Test
    public void testInternalFilterEvents() {
        HtmlFilter filter = new HtmlFilter();
        EventListBuilderStep elbs1 = new EventListBuilderStep();
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("/form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)filter), elbs1}).execute();
        List list = elbs1.getList();
        Assert.assertEquals((long)109L, (long)list.size());
        DocumentPart dp = ((Event)list.get(1)).getDocumentPart();
        Assert.assertEquals((Object)"dp2", (Object)dp.getId());
        Assert.assertEquals((Object)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=[#$$self$@%encoding]\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(91)).getDocumentPart();
        Assert.assertEquals((Object)"dp53", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"BB\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(93)).getDocumentPart();
        Assert.assertEquals((Object)"dp54", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"CR\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(95)).getDocumentPart();
        Assert.assertEquals((Object)"dp55", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"AFL\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(97)).getDocumentPart();
        Assert.assertEquals((Object)"dp56", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"SOC\">", (Object)dp.getSkeleton().toString());
        ITextUnit tu = ((Event)list.get(84)).getTextUnit();
        Assert.assertEquals((Object)"tu33", (Object)tu.getId());
        Assert.assertEquals((Object)"<input type=\"radio\" name=\"FavouriteFare\" [#$tu34] checked=\"checked\" /> Spam <input type=\"radio\" name=\"FavouriteFare\" [#$tu35] /> Rhubarb <input type=\"radio\" name=\"FavouriteFare\" [#$tu36] /> Honey <input type=\"radio\" name=\"FavouriteFare\" [#$tu37] /> Rum", (Object)tu.getSource().toString());
        tu = ((Event)list.get(105)).getTextUnit();
        Assert.assertEquals((Object)"tu45", (Object)tu.getId());
        Assert.assertEquals((Object)"<input type=\"submit\" [#$tu46] name=\"button1\"/>", (Object)tu.getSource().toString());
    }

    @Test
    public void testTransformedEvents() {
        PreprocessingFilter filter = new PreprocessingFilter((IFilter)new HtmlFilter(), new IPipelineStep[]{new ResourceSimplifierStep()});
        EventListBuilderStep elbs1 = new EventListBuilderStep();
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("/form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)filter), elbs1}).execute();
        List list = elbs1.getList();
        Assert.assertEquals((long)121L, (long)list.size());
        DocumentPart dp = ((Event)list.get(1)).getDocumentPart();
        Assert.assertEquals((Object)"dp2", (Object)dp.getId());
        Assert.assertEquals((Object)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(103)).getDocumentPart();
        Assert.assertEquals((Object)"dp53", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"BB\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(105)).getDocumentPart();
        Assert.assertEquals((Object)"dp54", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"CR\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(107)).getDocumentPart();
        Assert.assertEquals((Object)"dp55", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"AFL\">", (Object)dp.getSkeleton().toString());
        dp = ((Event)list.get(109)).getDocumentPart();
        Assert.assertEquals((Object)"dp56", (Object)dp.getId());
        Assert.assertEquals((Object)"<option value=\"SOC\">", (Object)dp.getSkeleton().toString());
        ITextUnit tu = ((Event)list.get(94)).getTextUnit();
        Assert.assertEquals((Object)"tu33", (Object)tu.getId());
        Assert.assertEquals((Object)"<input type=\"radio\" name=\"FavouriteFare\" value=\"spam\" checked=\"checked\" /> Spam <input type=\"radio\" name=\"FavouriteFare\" value=\"rhubarb\" /> Rhubarb <input type=\"radio\" name=\"FavouriteFare\" value=\"honey\" /> Honey <input type=\"radio\" name=\"FavouriteFare\" value=\"rum\" /> Rum", (Object)tu.getSource().toString());
        tu = ((Event)list.get(117)).getTextUnit();
        Assert.assertEquals((Object)"tu45", (Object)tu.getId());
        Assert.assertEquals((Object)"<input type=\"submit\" value=\"Submit Form\" name=\"button1\"/>", (Object)tu.getSource().toString());
    }
}

