/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.common;

import java.security.InvalidParameterException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.lib.preprocessing.filters.common.PreprocessingFilter;
import net.sf.okapi.steps.common.ResourceSimplifierStep;
import net.sf.okapi.steps.common.codesimplifier.CodeSimplifierStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestConstructor {
    private PreprocessingFilter filter;
    private IFilter internalFilter;

    @Test(expected=InvalidParameterException.class)
    public void testConstructor_filter_noSteps() {
        this.internalFilter = new XmlStreamFilter();
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[0]);
        Assert.assertNotNull((Object)this.filter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }

    @Test
    public void testConstructor_filter_oneStep() {
        this.internalFilter = new XmlStreamFilter();
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[]{new ResourceSimplifierStep()});
        Assert.assertNotNull((Object)this.filter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }

    @Test
    public void testConstructor_filter_twoSteps() {
        this.internalFilter = new XmlStreamFilter();
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[]{new ResourceSimplifierStep(), new CodeSimplifierStep()});
        Assert.assertNotNull((Object)this.filter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }

    @Test(expected=InvalidParameterException.class)
    public void testConstructor_noFilter_noSteps() {
        this.internalFilter = null;
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[0]);
        Assert.assertNotNull((Object)this.filter);
        Assert.assertNull((Object)this.internalFilter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }

    @Test(expected=InvalidParameterException.class)
    public void testConstructor_noFilter_oneStep() {
        this.internalFilter = null;
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[]{new ResourceSimplifierStep()});
        Assert.assertNotNull((Object)this.filter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }

    @Test(expected=InvalidParameterException.class)
    public void testConstructor_noFilter_twoSteps() {
        this.internalFilter = null;
        this.filter = new PreprocessingFilter(this.internalFilter, new IPipelineStep[]{new ResourceSimplifierStep(), new CodeSimplifierStep()});
        Assert.assertNotNull((Object)this.filter);
        Assert.assertEquals((Object)this.internalFilter, (Object)this.filter.getFilter());
    }
}

