/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.common;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.lib.preprocessing.filters.simplification.Parameters;
import net.sf.okapi.lib.preprocessing.filters.simplification.SimplificationFilter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestConfigurations {
    private static final LocaleId ENUS = new LocaleId("en", "us");

    @Test
    public void testConfigurations() {
        SimplificationFilter filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter.getFilter() instanceof XmlStreamFilter));
        Parameters params = filter.getParameters();
        Assert.assertTrue((boolean)params.isSimplifyResources());
        Assert.assertTrue((boolean)params.isSimplifyCodes());
        filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification-xmlResources");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter.getFilter() instanceof XmlStreamFilter));
        params = filter.getParameters();
        Assert.assertTrue((boolean)params.isSimplifyResources());
        Assert.assertFalse((boolean)params.isSimplifyCodes());
        filter = (SimplificationFilter)FilterUtil.createFilter((String)"okf_simplification-xmlCodes");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter.getFilter() instanceof XmlStreamFilter));
        params = filter.getParameters();
        Assert.assertFalse((boolean)params.isSimplifyResources());
        Assert.assertTrue((boolean)params.isSimplifyCodes());
    }

    @Test
    public void testStartDocument() {
        SimplificationFilter filter = new SimplificationFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter.getFilter() instanceof XmlStreamFilter));
        Parameters params = filter.getParameters();
        Assert.assertEquals((Object)"okf_xmlstream", (Object)params.getFilterConfigId());
        Assert.assertTrue((boolean)params.isSimplifyResources());
        Assert.assertFalse((boolean)params.isSimplifyCodes());
        params.setFilterConfigId("okf_html");
        Assert.assertTrue((boolean)(filter.getFilter() instanceof XmlStreamFilter));
        Assert.assertEquals((Object)"okf_html", (Object)params.getFilterConfigId());
        filter.open(new RawDocument((CharSequence)"test", ENUS));
        Assert.assertTrue((boolean)(filter.getFilter() instanceof HtmlFilter));
        Assert.assertTrue((boolean)filter.hasNext());
        Event e = filter.next();
        Assert.assertTrue((boolean)e.isStartDocument());
        StartDocument sd = e.getStartDocument();
        Assert.assertNotNull((Object)sd);
        Assert.assertEquals((Object)params, (Object)sd.getFilterParameters());
        filter.close();
    }
}

