/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.common;

import java.util.ArrayList;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.lib.preprocessing.filters.common.PreprocessingFilter;
import net.sf.okapi.steps.common.ResourceSimplifierStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestDoubleExtraction {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private FileLocation root;

    @Before
    public void startUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testDoubleExtraction() {
        PreprocessingFilter filter = new PreprocessingFilter((IFilter)new HtmlFilter(), new IPipelineStep[]{new ResourceSimplifierStep()});
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.root.in("/aa324.html").toString(), null));
        list.add(new InputDocument(this.root.in("/form.html").toString(), null));
        list.add(new InputDocument(this.root.in("/W3CHTMHLTest1.html").toString(), null));
        list.add(new InputDocument(this.root.in("/msg00058.html").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)filter, list, "UTF-8", ENUS, ENUS, "out"));
    }
}

