/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.simplification;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String FILTERCONFIGID = "filterConfigId";
    private static final String SIMPLIFYRESOURCES = "simplifyResources";
    private static final String SIMPLIFYCODES = "simplifyCodes";

    public void reset() {
        super.reset();
        this.setFilterConfigId("okf_xmlstream");
        this.setSimplifyResources(true);
        this.setSimplifyCodes(false);
    }

    public String getFilterConfigId() {
        return this.getString(FILTERCONFIGID);
    }

    public void setFilterConfigId(String filterConfigId) {
        this.setString(FILTERCONFIGID, filterConfigId);
    }

    public boolean isSimplifyResources() {
        return this.getBoolean(SIMPLIFYRESOURCES);
    }

    public void setSimplifyResources(boolean simplifyResources) {
        this.setBoolean(SIMPLIFYRESOURCES, simplifyResources);
    }

    public boolean isSimplifyCodes() {
        return this.getBoolean(SIMPLIFYCODES);
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.setBoolean(SIMPLIFYCODES, simplifyCodes);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(FILTERCONFIGID, "Filter configuration ID", null);
        desc.add(SIMPLIFYRESOURCES, "Simplify resources", "Simplify resources generated by the filter removing references in resources (resource flattening)");
        desc.add(SIMPLIFYCODES, "Simplify codes", "Merge adjacent inline codes in the source part of a text unit, moves leading and trailing codes to the skeleton");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Simplification Filter Parameters", true, false);
        desc.addTextInputPart(parametersDescription.get(FILTERCONFIGID));
        desc.addCheckboxPart(parametersDescription.get(SIMPLIFYRESOURCES));
        desc.addCheckboxPart(parametersDescription.get(SIMPLIFYCODES));
        return desc;
    }
}

