/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.List;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMergerSerialized
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params = new Parameters();

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTran) {
        boolean segmentationSupported;
        if (tuFromSkel == null || tuFromTran == null) {
            this.LOGGER.warn("Null TextUnit in TextUnitMerger.");
            return tuFromSkel;
        }
        String translatedTuId = tuFromTran.getId();
        if (!tuFromSkel.getId().equals(tuFromTran.getId())) {
            String s = String.format("Text Unit id mismatch during merger: Original id=\"%s\" target id=\"%s\"", tuFromSkel.getId(), tuFromTran.getId());
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentIdException()) {
                throw new OkapiMergeException(s);
            }
        }
        ITextUnit mergedTextUnit = tuFromSkel;
        ITextUnit tuFromSkelClone = tuFromSkel.clone();
        if (this.params.isCopySourceIfNonTextual() && !tuFromSkel.getSource().hasText(true) && (tuFromTran.getTarget(this.trgLoc) == null || tuFromTran.getTarget(this.trgLoc).isEmpty())) {
            mergedTextUnit.setTarget(this.trgLoc, tuFromSkel.getSource().clone());
            return mergedTextUnit;
        }
        if (!tuFromTran.hasTarget(this.trgLoc) || tuFromTran.getTarget(this.trgLoc) == null) {
            this.LOGGER.warn("No translation found for TU id='{}'.", (Object)tuFromTran.getId());
            return mergedTextUnit;
        }
        boolean isTransApproved = false;
        Property traProp = tuFromTran.getTarget(this.trgLoc).getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved. Using empty translation.", (Object)tuFromSkel.getId());
            mergedTextUnit.setTarget(this.trgLoc, null);
            return mergedTextUnit;
        }
        mergedTextUnit.setSource(tuFromTran.getSource().clone());
        mergedTextUnit.setTarget(this.trgLoc, tuFromTran.getTarget(this.trgLoc).clone());
        if (mergedTextUnit.getSkeleton() != null) {
            mergedTextUnit.getSkeleton().setParent((IResource)mergedTextUnit);
        }
        IResource.copy((IResource)tuFromSkelClone.getSource(), (IResource)mergedTextUnit.getSource());
        IResource.copy((IResource)tuFromSkelClone.getTarget(this.trgLoc), (IResource)mergedTextUnit.getTarget(this.trgLoc));
        boolean keepCodeIds = segmentationSupported = MimeTypeMapper.isSegmentationSupported((String)tuFromSkelClone.getMimeType());
        List srcRanges = null;
        List trgRanges = null;
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            srcRanges = mergedTextUnit.getSource().getSegments().getRanges(keepCodeIds);
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            trgRanges = mergedTextUnit.getTarget(this.trgLoc).getSegments().getRanges(keepCodeIds);
        }
        for (TextPart tp : mergedTextUnit.getSource().getSegments()) {
            if (!TextUnitUtil.hasMergedCode((TextFragment)tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes((TextFragment)tp.text);
        }
        for (TextPart tp : mergedTextUnit.getTarget(this.trgLoc).getSegments()) {
            if (!TextUnitUtil.hasMergedCode((TextFragment)tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes((TextFragment)tp.text);
        }
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            mergedTextUnit.getSource().getSegments().joinAll(keepCodeIds);
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().joinAll(keepCodeIds);
        }
        TextFragment from = mergedTextUnit.getSource().getFirstContent();
        TextFragment to = mergedTextUnit.getTarget(this.trgLoc).getFirstContent();
        CodeMatches cm = TextFragmentUtil.synchronizeCodeIds((TextFragment)from, (TextFragment)to, (CodeMatchStrategy)CodeMatchStrategy.STRICT);
        if (this.params.isAddMissing() && (cm.hasFromMismatch() || cm.hasToMismatch())) {
            TextFragmentUtil.addMissingCodes((TextFragment)from, (TextFragment)to, (CodeMatches)cm);
            to.invalidate();
            to.balanceMarkers();
        }
        if (cm.hasFromMismatch(false) || cm.hasToMismatch(false)) {
            TextFragmentUtil.logCodeMismatchErrors((CodeMatches)cm, (TextFragment)from, (TextFragment)to, (String)translatedTuId);
            if (this.params.isThrowCodeException()) {
                throw new OkapiMergeException("Missing or Added codes for TU: " + translatedTuId);
            }
        }
        if (mergedTextUnit.getSource().getSegments().count() != mergedTextUnit.getTarget(this.trgLoc).getSegments().count()) {
            this.LOGGER.warn("Item id='{}': Different number of source and target segments.", (Object)tuFromTran.getId());
        }
        if (srcRanges != null && segmentationSupported) {
            mergedTextUnit.getSource().getSegments().create(srcRanges, true, ISegments.MetaCopyStrategy.IDENTITY);
        }
        if (trgRanges != null && segmentationSupported) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().create(trgRanges, true, ISegments.MetaCopyStrategy.IDENTITY);
        }
        return mergedTextUnit;
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }
}

