/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.io.OutputStream;
import java.util.HashSet;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.exceptions.OkapiUnexpectedResourceTypeException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;

public class SkeletonMergerWriter
implements IFilterWriter {
    private IFilter skeletonFilter;
    private String outputPath;
    private OutputStream outputStream;
    private LocaleId targetLocale;
    private String encoding;
    private IFilterWriter writer;
    private Parameters params = new Parameters();
    private ITextUnitMerger textUnitMerger;

    public SkeletonMergerWriter() {
        this.textUnitMerger = new TextUnitMerger();
    }

    public SkeletonMergerWriter(ITextUnitMerger textUnitMerger) {
        this.textUnitMerger = textUnitMerger;
    }

    public SkeletonMergerWriter(IFilter skeletonFilter, IFilterWriter writer, ITextUnitMerger textUnitMerger) {
        this();
        this.skeletonFilter = skeletonFilter;
        this.writer = writer;
        if (textUnitMerger != null) {
            this.textUnitMerger = textUnitMerger;
        }
    }

    public SkeletonMergerWriter(IFilter skeletonFilter, ITextUnitMerger textUnitMerger) {
        this();
        this.skeletonFilter = skeletonFilter;
        if (textUnitMerger != null) {
            this.textUnitMerger = textUnitMerger;
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setOptions(LocaleId targetLocale, String defaultEncoding) {
        this.targetLocale = targetLocale;
        this.encoding = defaultEncoding;
        this.textUnitMerger.setTargetLocale(targetLocale);
    }

    public void setOutput(String path) {
        this.outputPath = path;
    }

    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
        }
        return event;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = null;
        this.skeletonFilter.close();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        this.textUnitMerger.setParameters(this.params);
    }

    public void cancel() {
        this.close();
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    protected void processStartDocument() {
        Event skelEvent = this.skeletonFilter.next();
        if (skelEvent == null || !skelEvent.isStartDocument()) {
            throw new OkapiUnexpectedResourceTypeException("The start document event can't be found in the skeleton file.");
        }
        StartDocument sd = skelEvent.getStartDocument();
        if (this.writer == null) {
            this.writer = sd.getFilterWriter();
        }
        this.writer.setOptions(this.targetLocale, this.encoding);
        if (this.outputStream != null) {
            this.writer.setOutput(this.outputStream);
        } else if (!Util.isEmpty((String)this.outputPath)) {
            this.writer.setOutput(this.outputPath);
        } else {
            throw new OkapiIOException("Output path or stream not defined for filter writer");
        }
        this.writer.handleEvent(skelEvent);
    }

    protected void processTextUnit(Event event) {
        ITextUnit tuFromTrans = event.getTextUnit();
        Event oriEvent = this.processUntilTextUnit();
        if (oriEvent == null) {
            throw new OkapiMergeException(String.format("No corresponding TextUnit for id='%s' in the skeleton file.", tuFromTrans.getId()));
        }
        ITextUnit tuFromSkel = oriEvent.getTextUnit();
        if (!tuFromSkel.isTranslatable()) {
            this.writer.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tuFromSkel));
            return;
        }
        ITextUnit mergedTu = this.textUnitMerger.mergeTargets(tuFromSkel, tuFromTrans);
        this.copyNotes((IWithAnnotations)tuFromTrans, (IWithAnnotations)mergedTu);
        this.writer.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)mergedTu));
    }

    protected void copyNotes(IWithAnnotations fromTrans, IWithAnnotations merged) {
        Parameters.NoteMergeStrategy mergeStrategy = this.params.getNoteMergeStrategy();
        if (mergeStrategy == Parameters.NoteMergeStrategy.DISCARD) {
            return;
        }
        NoteAnnotation existingNotes = (NoteAnnotation)merged.getAnnotation(NoteAnnotation.class);
        HashSet result = new HashSet();
        if (existingNotes == null || mergeStrategy == Parameters.NoteMergeStrategy.REPLACE) {
            existingNotes = new NoteAnnotation();
        }
        existingNotes.forEach(result::add);
        NoteAnnotation notesFromTrans = (NoteAnnotation)fromTrans.getAnnotation(NoteAnnotation.class);
        if (notesFromTrans == null) {
            return;
        }
        notesFromTrans.forEach(result::add);
        merged.setAnnotation((IAnnotation)new NoteAnnotation(result));
    }

    protected Event processUntilTextUnit() {
        Event event = null;
        while (this.skeletonFilter.hasNext()) {
            event = this.skeletonFilter.next();
            if (event == null) {
                return event;
            }
            if (event.isTextUnit()) {
                return event;
            }
            this.writer.handleEvent(event);
        }
        return event;
    }

    protected void processEndDocument() {
        this.flushFilterEvents();
    }

    private void flushFilterEvents() {
        try {
            while (this.skeletonFilter.hasNext()) {
                Event event = this.skeletonFilter.next();
                if (event.isTextUnit()) {
                    throw new OkapiMergeException(String.format("No corresponding text unit for id='%s' in the skeleton file.", event.getTextUnit().getId()));
                }
                this.writer.handleEvent(event);
            }
        }
        finally {
            this.writer.close();
        }
    }

    public void setWriter(IFilterWriter writer) {
        this.writer = writer;
    }

    public void setFilter(IFilter skeletonFilter) {
        this.skeletonFilter = skeletonFilter;
        if (skeletonFilter.getParameters() != null) {
            this.params.fromString(skeletonFilter.getParameters().toString(), false);
        }
    }
}

