/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.merge.merge.MergerUtil;
import net.sf.okapi.lib.merge.merge.Parameters;
import net.sf.okapi.lib.merge.step.OriginalDocumentXliffMergerStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OriginalDocumentXliffMergerStepTest {
    private HtmlFilter htmlFilter;
    private XLIFFFilter xliffFilter;
    private FileLocation root;
    private OriginalDocumentXliffMergerStep merger;
    private RawDocumentWriterStep writer;

    @Before
    public void setUp() {
        this.htmlFilter = new HtmlFilter();
        this.xliffFilter = new XLIFFFilter();
        this.merger = new OriginalDocumentXliffMergerStep();
        this.writer = new RawDocumentWriterStep();
        this.root = FileLocation.fromClass(this.getClass());
    }

    @After
    public void tearDown() {
        this.htmlFilter.close();
        this.merger.destroy();
        this.writer.destroy();
    }

    @Test
    public void simpleMerge() {
        String input = "/simple.html";
        MergerUtil.writeXliffAndSkeleton(FilterTestDriver.getEvents((IFilter)this.htmlFilter, (RawDocument)new RawDocument(this.root.in(input).asInputStream(), "UTF-8", LocaleId.ENGLISH), null), this.root.out("").toString(), this.root.out(input + ".xlf").toString());
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(this.root.in(input).asInputStream(), "UTF-8", LocaleId.ENGLISH);
        rd.setFilterConfigId("okf_html");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.FRENCH);
        this.merger.setTargetLocales(ts);
        URI tempXlf = this.root.out(input + ".xlf").asUri();
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(tempXlf, "UTF-8", LocaleId.ENGLISH, LocaleId.ENGLISH)));
        this.writer.setOutputURI(this.root.out(input + ".merged").asUri());
        this.writer.handleEvent(e);
        this.writer.destroy();
        URI tempMerged = this.root.out(input + ".merged").asUri();
        RawDocument ord = new RawDocument(this.root.in(input).asInputStream(), "UTF-8", LocaleId.ENGLISH);
        RawDocument trd = new RawDocument(tempMerged, "UTF-8", LocaleId.ENGLISH);
        ArrayList<Event> o = MergerUtil.getTextUnitEvents((IFilter)this.htmlFilter, ord);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.htmlFilter, trd);
        Assert.assertTrue((o.size() == t.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FilterTestDriver.compareEvents(o, t, (boolean)true));
    }

    @Test
    public void testReplaceNotesOnMerge() {
        List<Note> notes = this.testNoteMerge(Parameters.NoteMergeStrategy.REPLACE, ".modified.xlf");
        Assert.assertEquals((long)1L, (long)notes.size());
        Assert.assertEquals((Object)"New note", (Object)notes.get(0).getNoteText());
    }

    @Test
    public void testMergeNotesOnMerge() {
        List<Note> notes = this.testNoteMerge(Parameters.NoteMergeStrategy.MERGE, ".modified.xlf");
        Assert.assertEquals((long)2L, (long)notes.size());
        Assert.assertTrue((boolean)notes.stream().map(Note::getNoteText).filter(t -> "Original note".equals(t)).findFirst().isPresent());
        Assert.assertTrue((boolean)notes.stream().map(Note::getNoteText).filter(t -> "New note".equals(t)).findFirst().isPresent());
    }

    @Test
    public void testMergeNotesAndConsolidateDuplicatesOnMerge() {
        List<Note> notes = this.testNoteMerge(Parameters.NoteMergeStrategy.MERGE, "");
        Assert.assertEquals((long)1L, (long)notes.size());
        Assert.assertEquals((Object)"Original note", (Object)notes.get(0).getNoteText());
    }

    @Test
    public void testDiscardNotesOnMerge() {
        List<Note> notes = this.testNoteMerge(Parameters.NoteMergeStrategy.DISCARD, ".modified.xlf");
        Assert.assertEquals((long)1L, (long)notes.size());
        Assert.assertEquals((Object)"Original note", (Object)notes.get(0).getNoteText());
    }

    private List<Note> testNoteMerge(Parameters.NoteMergeStrategy strategy, String translatedFileSuffix) {
        String input = "/test.xlf";
        MergerUtil.writeXliffAndSkeleton(FilterTestDriver.getEvents((IFilter)this.xliffFilter, (RawDocument)new RawDocument(this.root.in(input).asInputStream(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH), null), this.root.out("").toString(), this.root.out(input + ".xlf").toString());
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)fcm, (boolean)true, (boolean)true);
        this.merger.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.merger.setOutputEncoding("UTF-8");
        RawDocument rd = new RawDocument(this.root.in(input).asInputStream(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH);
        rd.setFilterConfigId("okf_xliff");
        this.merger.setSecondInput(rd);
        LinkedList<LocaleId> ts = new LinkedList<LocaleId>();
        ts.add(LocaleId.SPANISH);
        this.merger.setTargetLocales(ts);
        this.merger.getSkelMergerWriter().getParameters().setNoteMergeStrategy(strategy);
        Event e = this.merger.handleEvent(new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument(this.root.in(input + translatedFileSuffix).asInputStream(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH)));
        this.writer.setOutputURI(this.root.out(input + ".merged").asUri());
        this.writer.handleEvent(e);
        this.writer.destroy();
        URI tempMerged = this.root.out(input + ".merged").asUri();
        RawDocument trd = new RawDocument(tempMerged, "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH);
        ArrayList<Event> t = MergerUtil.getTextUnitEvents((IFilter)this.xliffFilter, trd);
        Assert.assertEquals((long)1L, (long)t.size());
        ITextUnit tu = ((Event)t.get(0)).getTextUnit();
        NoteAnnotation anno = (NoteAnnotation)tu.getAnnotation(NoteAnnotation.class);
        Assert.assertNotNull((Object)anno);
        return StreamSupport.stream(anno.spliterator(), false).collect(Collectors.toList());
    }
}

