/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TextUnitMergerTest {
    private static final String XLFSTART = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n";
    private static final String XLFEND = "\n</trans-unit></body></file></xliff>";
    private HtmlFilter htmlFilter;
    private ITextUnitMerger merger;

    @Before
    public void setUp() {
        this.htmlFilter = new HtmlFilter();
        this.merger = new TextUnitMerger();
        this.merger.setTargetLocale(LocaleId.FRENCH);
        this.merger.setParameters(new Parameters());
    }

    @After
    public void tearDown() {
        this.htmlFilter.close();
    }

    @Test
    public void mergeWithoutCodes() {
        String srcSnippet = "<p>Before bold after.</p>";
        String trgSnippet = "<p>french for what he said.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"french for what he said.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test
    public void mergeWithBalancedCodes() {
        String srcSnippet = "<p>Before <b>bold</b> <img href=\"there\" alt=\"text\"/> after.</p>";
        String trgSnippet = "<p>XXXXXX <b>XXXX <img href=\"XXXXX\" alt=\"XXXX\"/> XXXX</b>.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)2);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)2);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"XXXXXX <b>XXXX [#$dp1] XXXX</b>.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test
    public void mergeWithStandaloneCodes() {
        String srcSnippet = "<p>Before <b>bold<i> after.</p>";
        String trgSnippet = "<p>XXXXXX <i>XXXX<b> XXXX.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"XXXXXX <i>XXXX<b> XXXX.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test
    public void mergeWithMovedBalancedCodes() {
        String srcSnippet = "<p><i>Before</i> <b>bold</b> after.</p>";
        String trgSnippet = "<p><b>XXXXXX</b> <i>XXXX</i> XXXX.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"<b>XXXXXX</b> <i>XXXX</i> XXXX.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test(expected=OkapiMergeException.class)
    public void mergeWithMissingBalancedCodes() {
        String srcSnippet = "<p><i>Before</i> <b>bold</b> after.</p>";
        String trgSnippet = "<p><b>XXXXXX</b> XXXX XXXX.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        TextUnitMerger m = new TextUnitMerger();
        m.setTargetLocale(LocaleId.FRENCH);
        Parameters p = new Parameters();
        p.setThrowCodeException(true);
        p.setAddMissing(false);
        m.setParameters(p);
        ITextUnit mergedTu = m.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"<b>XXXXXX</b> XXXX XXXX.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test(expected=OkapiMergeException.class)
    public void mergeWithAddedBalancedCodes() {
        String srcSnippet = "<p><i>Before</i> <b>bold</b> after.</p>";
        String trgSnippet = "<p><i>XXXXXX</i> <b>XXXX</b> <u><u>XXXX</u></u>.</p>";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        TextUnitMerger m = new TextUnitMerger();
        m.setTargetLocale(LocaleId.FRENCH);
        Parameters p = new Parameters();
        p.setThrowCodeException(true);
        p.setAddMissing(false);
        m.setParameters(p);
        ITextUnit mergedTu = m.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"<i>XXXXXX</i> <b>XXXX</b> <u><u>XXXX</u></u>.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
    }

    @Test
    public void mergeCodesWithSegments() {
        String srcSnippet = "A segment without codes. A segment with <b>codes</b>. <i>And another segment</i>.";
        String trgSnippet = "A segment without codes and segment with <i>codes</i>. <b>And another segment</b>.";
        ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)srcSnippet, (LocaleId)LocaleId.ENGLISH), (int)1);
        tuFromSkeleton.createSourceSegmentation(this.createSegmenterWithRules(LocaleId.ENGLISH));
        ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)this.htmlFilter, (String)trgSnippet, (LocaleId)LocaleId.FRENCH), (int)1);
        tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
        tuFromTrans.setSource(tuFromSkeleton.getSource());
        ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
        Assert.assertEquals((Object)"A segment without codes and segment with <i>codes</i>. <b>And another segment</b>.", (Object)mergedTu.getTarget(LocaleId.FRENCH).toString());
        IAlignedSegments segments = mergedTu.getAlignedSegments();
        Assert.assertEquals((Object)AlignmentStatus.ALIGNED, (Object)segments.getAlignmentStatus());
        Assert.assertEquals((long)1L, (long)mergedTu.getSourceSegments().count());
        Segment src = segments.getSource(0, LocaleId.FRENCH);
        Segment trg = segments.getCorrespondingTarget(src, LocaleId.FRENCH);
        Assert.assertNotNull((Object)trg);
        GenericContent fmt = new GenericContent();
        Assert.assertEquals((Object)"[A segment without codes. A segment with <b>codes</b>. <i>And another segment</i>.]", (Object)fmt.printSegmentedContent(mergedTu.getSource(), true, true));
        Assert.assertEquals((Object)"[A segment without codes and segment with <i>codes</i>. <b>And another segment</b>.]", (Object)fmt.printSegmentedContent(mergedTu.getTarget(LocaleId.FRENCH), true, true));
    }

    @Test
    public void testXLIFF() {
        String srcSnippet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n\n</trans-unit></body></file></xliff>";
        String trgSnippet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1.</mrk> <mrk id=\"s2\" mtype=\"seg\">Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>";
        try (XLIFFFilter xliffFilter = new XLIFFFilter();){
            ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)xliffFilter, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n\n</trans-unit></body></file></xliff>", (LocaleId)LocaleId.ENGLISH, (LocaleId)LocaleId.FRENCH), (int)1);
            ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)xliffFilter, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1.</mrk> <mrk id=\"s2\" mtype=\"seg\">Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>", (LocaleId)LocaleId.ENGLISH, (LocaleId)LocaleId.FRENCH), (int)1);
            tuFromTrans.createTarget(LocaleId.FRENCH, false, 7);
            tuFromTrans.setSource(tuFromSkeleton.getSource());
            Assert.assertEquals((Object)true, (Object)tuFromTrans.hasTarget(LocaleId.FRENCH));
            ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
            TextContainer tc = mergedTu.getTarget(LocaleId.FRENCH);
            Assert.assertEquals((Object)"fromTTarget1. Target2.", (Object)tc.toString());
            Code code = tc.getFirstContent().getCode(0);
            Assert.assertEquals((Object)"<ph id=\"1\" ts=\"z\">C1</ph>", (Object)code.getOuterData());
            Assert.assertEquals((long)2L, (long)tc.getSegments().count());
        }
    }

    @Test
    public void testXLIFFCollapseSegments() {
        String original = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1. Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>";
        String translated = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1. Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>";
        try (XLIFFFilter xliffFilter = new XLIFFFilter();){
            ITextUnit tuFromSkeleton = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)xliffFilter, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source.</mrk> <mrk id=\"s2\" mtype=\"seg\">Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1. Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>", (LocaleId)LocaleId.ENGLISH, (LocaleId)LocaleId.FRENCH), (int)1);
            ITextUnit tuFromTrans = FilterTestDriver.getTextUnit((List)FilterTestDriver.getEvents((IFilter)xliffFilter, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xliff version=\"1.2\"><file source-language=\"en\" target-language=\"fr\" datatype=\"x-test\" original=\"file.ext\"><body><trans-unit id=\"1\"><source>\n<ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</source>\n<seg-source><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">C1</ph>Source. Text.</mrk></seg-source>\n<target><mrk id=\"s1\" mtype=\"seg\"><ph id=\"1\" ts=\"z\">fromT</ph>Target1. Target2.</mrk></target>\n\n</trans-unit></body></file></xliff>", (LocaleId)LocaleId.ENGLISH, (LocaleId)LocaleId.FRENCH), (int)1);
            Assert.assertEquals((Object)true, (Object)tuFromTrans.hasTarget(LocaleId.FRENCH));
            Assert.assertEquals((long)3L, (long)tuFromSkeleton.getSource().count());
            Assert.assertEquals((long)1L, (long)tuFromSkeleton.getTarget(LocaleId.FRENCH).count());
            Assert.assertEquals((long)1L, (long)tuFromTrans.getSource().count());
            Assert.assertEquals((long)1L, (long)tuFromTrans.getTarget(LocaleId.FRENCH).count());
            ITextUnit mergedTu = this.merger.mergeTargets(tuFromSkeleton, tuFromTrans);
            Assert.assertEquals((long)1L, (long)mergedTu.getSource().count());
            Assert.assertEquals((long)1L, (long)mergedTu.getTarget(LocaleId.FRENCH).count());
            TextContainer tc = mergedTu.getTarget(LocaleId.FRENCH);
            Assert.assertEquals((Object)"fromTTarget1. Target2.", (Object)tc.toString());
            Code code = tc.getFirstContent().getCode(0);
            Assert.assertEquals((Object)"<ph id=\"1\" ts=\"z\">fromT</ph>", (Object)code.getOuterData());
            Assert.assertEquals((long)1L, (long)tc.getSegments().count());
        }
    }

    private ISegmenter createSegmenterWithRules(LocaleId locId) {
        SRXDocument doc = new SRXDocument();
        LanguageMap langMap = new LanguageMap(".*", "default");
        doc.addLanguageMap(langMap);
        ArrayList<Rule> langRules = new ArrayList<Rule>();
        langRules.add(new Rule("\\.", "\\s", true));
        doc.addLanguageRule("default", langRules);
        return doc.compileLanguageRules(locId, null);
    }
}

