/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeAnomalies;
import net.sf.okapi.common.resource.CodeComparatorOnIdAndType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextPartComparator;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import org.incava.diff.LCS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMerger
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params = new Parameters();
    private List<Range> srcRanges;
    private List<Range> trgRanges;

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTran) {
        CodeAnomalies codeAnomalies;
        String sourceFromTranslated;
        String originalSource;
        if (tuFromSkel == null || tuFromTran == null) {
            this.LOGGER.warn("Null TextUnit in TextUnitMerger.");
            return tuFromSkel;
        }
        if (!tuFromSkel.getId().equals(tuFromTran.getId())) {
            String s = String.format("Text Unit id mismatch during merger: Original id=\"%s\" target id=\"%s\"", tuFromSkel.getId(), tuFromTran.getId());
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentIdException()) {
                throw new OkapiMergeException(s);
            }
        }
        if (!(originalSource = StringUtil.removeWhiteSpace((String)tuFromSkel.getSource().createJoinedContent().getText())).equals(sourceFromTranslated = StringUtil.removeWhiteSpace((String)tuFromTran.getSource().createJoinedContent().getText()))) {
            String s = String.format("Text Unit source mismatch during merge: Original id=\"%s\" target id=\"%s\"\nOriginal Source=\"%s\"\nTranslated Source=\"%s\"", tuFromSkel.getId(), tuFromTran.getId(), originalSource, sourceFromTranslated);
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentSourceException()) {
                throw new OkapiMergeException(s);
            }
        }
        if (!tuFromTran.hasTarget(this.trgLoc) || tuFromTran.getTarget(this.trgLoc) == null) {
            if (tuFromSkel.getSource().hasText()) {
                this.LOGGER.warn("No translation found for TU id='{}'. Using source as translation.", (Object)tuFromTran.getId());
            }
            return tuFromSkel;
        }
        boolean isTransApproved = false;
        Property traProp = tuFromTran.getTarget(this.trgLoc).getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved. Skipping. Using source as translation.", (Object)tuFromSkel.getId());
            return tuFromSkel;
        }
        ITextUnit mergedTextUnit = tuFromSkel.clone();
        mergedTextUnit.setSource(tuFromTran.getSource().clone());
        mergedTextUnit.setTarget(this.trgLoc, tuFromTran.getTarget(this.trgLoc).clone());
        IWithProperties.copy((IWithProperties)tuFromSkel.getSource(), (IWithProperties)mergedTextUnit.getSource());
        IWithAnnotations.copy((IWithAnnotations)tuFromSkel.getSource(), (IWithAnnotations)mergedTextUnit.getSource());
        IWithProperties.copy((IWithProperties)tuFromSkel.getTarget(this.trgLoc), (IWithProperties)mergedTextUnit.getTarget(this.trgLoc));
        IWithAnnotations.copy((IWithAnnotations)tuFromSkel.getTarget(this.trgLoc), (IWithAnnotations)mergedTextUnit.getTarget(this.trgLoc));
        boolean mergeAsSegments = MimeTypeMapper.isSegmentationSupported((String)tuFromSkel.getMimeType());
        this.srcRanges = mergedTextUnit.getSource().getSegments().getRanges();
        this.trgRanges = mergedTextUnit.getTarget(this.trgLoc).getSegments().getRanges();
        for (TextPart tp : mergedTextUnit.getSource().getSegments()) {
            if (!TextUnitUtil.hasMergedCode((TextFragment)tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes((TextFragment)tp.text);
        }
        for (TextPart tp : mergedTextUnit.getTarget(this.trgLoc).getSegments()) {
            if (!TextUnitUtil.hasMergedCode((TextFragment)tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes((TextFragment)tp.text);
        }
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            mergedTextUnit.getSource().getSegments().joinAll();
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().joinAll();
        }
        this.removeOuterData(mergedTextUnit.getSource().getFirstContent().getCodes());
        this.removeOuterData(mergedTextUnit.getTarget(this.trgLoc).getFirstContent().getCodes());
        TextContainer skelContent = tuFromSkel.getSource();
        if (!tuFromSkel.getSource().contentIsOneSegment()) {
            skelContent = tuFromSkel.getSource().clone();
            skelContent.joinAll();
        }
        if ((codeAnomalies = TextFragmentUtil.catalogCodeAnomalies((TextFragment)mergedTextUnit.getSource().getFirstContent(), (TextFragment)mergedTextUnit.getTarget(this.trgLoc).getFirstContent())) != null) {
            StringBuilder e = new StringBuilder();
            e.append(String.format("Text Unit id: %s", tuFromTran.getId()));
            if (codeAnomalies.hasAddedCodes()) {
                e.append(String.format("\nAdded Codes in target='%s'", codeAnomalies.addedCodesAsString()));
            }
            if (codeAnomalies.hasMissingCodes()) {
                e.append(String.format("\nMissing Codes in target='%s'", codeAnomalies.missingCodesAsString()));
            }
            e.append("\nTarget Text Unit:\n");
            e.append(mergedTextUnit.getTarget(this.trgLoc).getFirstContent().toText());
            this.LOGGER.error(e.toString());
            if (this.params.isThrowCodeException()) {
                throw new OkapiMergeException(e.toString());
            }
        }
        this.copyCodeMeta(skelContent.getFirstContent(), mergedTextUnit.getSource().getFirstContent());
        this.copyCodeMeta(mergedTextUnit.getSource().getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent());
        if (mergeAsSegments) {
            if (!Util.isEmpty(this.srcRanges)) {
                mergedTextUnit.getSource().getSegments().create(this.srcRanges, true);
            }
            if (!Util.isEmpty(this.trgRanges)) {
                mergedTextUnit.getTarget(this.trgLoc).getSegments().create(this.trgRanges, true);
            }
        }
        if (mergedTextUnit.getSource().getSegments().count() != mergedTextUnit.getTarget(this.trgLoc).getSegments().count()) {
            this.LOGGER.warn("Item id='{}': Different number of source and target segments.", (Object)tuFromTran.getId());
        }
        if (mergeAsSegments) {
            this.copyTextPartMeta(tuFromSkel.getSource().getParts(), mergedTextUnit.getSource().getParts(), mergedTextUnit.getId());
            if (tuFromSkel.hasTarget(this.trgLoc)) {
                this.copyTextPartMeta(tuFromSkel.getTarget(this.trgLoc).getParts(), mergedTextUnit.getTarget(this.trgLoc).getParts(), mergedTextUnit.getId());
            }
        }
        return mergedTextUnit;
    }

    @Override
    public void copyTextPartMeta(List<TextPart> from, List<TextPart> to, String id) {
        if (Util.isEmpty(from) && Util.isEmpty(to)) {
            return;
        }
        TextPartComparator cmp = new TextPartComparator();
        boolean[] matched = new boolean[to.size()];
        Arrays.fill(matched, false);
        LCS diff = new LCS(from, to, (Comparator)cmp);
        List matches = diff.getMatches();
        int n = -1;
        for (Integer m : matches) {
            TextPart tp = null;
            TextPart origPart = from.get(++n);
            if (m == null && (tp = this.findMatch((Object)origPart, (List)to, matched, (Comparator)cmp)) == null) {
                if (this.hasMeta(origPart)) {
                    this.LOGGER.error("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Cannot copy TextPart properties/annotations. Merged file may differ from original", (Object)id, (Object)origPart.id);
                    continue;
                }
                this.LOGGER.warn("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Possible segmentation changes in the translated file", (Object)id, (Object)origPart.id);
                continue;
            }
            if (m != null) {
                tp = to.get(m);
                matched[m.intValue()] = true;
            }
            tp.originalId = origPart.originalId;
            IWithProperties.copy((IWithProperties)origPart, (IWithProperties)tp);
            IWithAnnotations.copy((IWithAnnotations)origPart, (IWithAnnotations)tp);
        }
    }

    private <T extends TextPart> boolean hasMeta(T p) {
        boolean hasProps = !p.getPropertyNames().isEmpty();
        boolean hasAnnotations = p.getAnnotations().iterator().hasNext();
        return hasProps || hasAnnotations || p.originalId != null;
    }

    @Override
    public void copyCodeMeta(TextFragment from, TextFragment to) {
        if (from == null || !from.hasCode()) {
            return;
        }
        if (to == null || !to.hasCode()) {
            return;
        }
        CodeComparatorOnIdAndType cmp = new CodeComparatorOnIdAndType();
        boolean[] matched = new boolean[to.getCodes().size()];
        Arrays.fill(matched, false);
        LCS diff = new LCS(from.getCodes(), to.getCodes(), (Comparator)cmp);
        List matches = diff.getMatches();
        int n = -1;
        for (Integer m : matches) {
            Code c = null;
            Code orig = from.getCode(++n);
            if (m == null && (c = this.findMatch((Object)orig, to.getCodes(), matched, (Comparator)cmp)) == null) {
                this.LOGGER.warn("Code id='{}': Can't find matching Code in merged text unit. Inserted or Deleted Code?", (Object)orig.getId());
                continue;
            }
            if (m != null) {
                c = to.getCode(m.intValue());
                matched[m.intValue()] = true;
            }
            this.copyCodeMeta(from.getCode(n), c);
        }
    }

    private <T> T findMatch(T orig, List<T> things, boolean[] matched, Comparator<T> cmp) {
        int i = -1;
        for (T t : things) {
            if (matched[++i] || cmp.compare(orig, t) != 0) continue;
            matched[i] = true;
            return t;
        }
        return null;
    }

    private void copyCodeMeta(Code sc, Code tc) {
        if (!tc.hasData()) {
            tc.setData(sc.getData());
        }
        tc.setOuterData(sc.getOuterData());
        tc.setOriginalId(sc.getOriginalId());
        tc.setAdded(sc.isAdded());
        tc.setCloneable(sc.isCloneable());
        tc.setDeleteable(sc.isDeleteable());
        tc.setDisplayText(sc.getDisplayText());
        tc.setFlag(sc.getFlag());
        tc.setMerged(sc.isMerged());
        tc.setMergedData(sc.getMergedData());
        tc.setTagType(sc.getTagType());
        Set types = sc.getAnnotationsTypes();
        for (String type : types) {
            InlineAnnotation a = sc.getAnnotation(type);
            tc.setAnnotation(type, a.clone());
        }
    }

    private void removeOuterData(List<Code> codes) {
        for (Code c : codes) {
            c.setOuterData(null);
        }
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }
}

