/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.exceptions.OkapiUnexpectedResourceTypeException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;

public class SkeletonMergerWriter
implements IFilterWriter {
    private IFilter skeletonFilter;
    private String outputPath;
    private OutputStream outputStream;
    private LocaleId targetLocale;
    private String encoding;
    private IFilterWriter writer;
    private Parameters params = new Parameters();
    private ITextUnitMerger textUnitMerger = new TextUnitMerger();

    public SkeletonMergerWriter() {
    }

    public SkeletonMergerWriter(IFilter skeletonFilter) {
        this();
        this.skeletonFilter = skeletonFilter;
    }

    public SkeletonMergerWriter(IFilter skeletonFilter, IFilterWriter writer) {
        this(skeletonFilter);
        this.writer = writer;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
        this.encoding = defaultEncoding;
    }

    public void setOutput(String path) {
        this.outputPath = path;
    }

    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event);
                break;
            }
        }
        return event;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = null;
        this.skeletonFilter.close();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    public void cancel() {
        this.close();
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    protected void processStartDocument(Event event) {
        Event skelEvent = this.skeletonFilter.next();
        if (skelEvent == null || !skelEvent.isStartDocument()) {
            throw new OkapiUnexpectedResourceTypeException("The start document event can't be found in the skeleton file.");
        }
        StartDocument sd = skelEvent.getStartDocument();
        if (this.writer == null) {
            this.writer = sd.getFilterWriter();
        }
        this.writer.setOptions(this.targetLocale, this.encoding);
        if (this.outputStream != null) {
            this.writer.setOutput(this.outputStream);
        } else if (!Util.isEmpty((String)this.outputPath)) {
            this.writer.setOutput(this.outputPath);
        } else {
            throw new OkapiIOException("Output path or stream not defined for filter writer");
        }
        this.writer.handleEvent(skelEvent);
        this.textUnitMerger.setParameters(this.params);
        this.textUnitMerger.setTargetLocale(this.targetLocale);
    }

    protected void processTextUnit(Event event) {
        ITextUnit tuFromTrans = event.getTextUnit();
        Event oriEvent = this.processUntilTextUnit();
        if (oriEvent == null) {
            throw new OkapiMergeException(String.format("No corresponding text unit for id='%s' in the skeleton file.", tuFromTrans.getId()));
        }
        ITextUnit tuFromSkel = oriEvent.getTextUnit();
        if (!tuFromSkel.isTranslatable()) {
            this.writer.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tuFromSkel));
            return;
        }
        ITextUnit mergedTu = this.textUnitMerger.mergeTargets(tuFromSkel, tuFromTrans);
        this.writer.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)mergedTu));
    }

    protected Event processUntilTextUnit() {
        Event event = null;
        while (this.skeletonFilter.hasNext()) {
            event = this.skeletonFilter.next();
            if (event == null) {
                return event;
            }
            if (event.isTextUnit()) {
                return event;
            }
            this.writer.handleEvent(event);
        }
        return event;
    }

    protected void processEndDocument(Event event) {
        this.flushFilterEvents();
    }

    private void flushFilterEvents() {
        try {
            Event event = null;
            while (this.skeletonFilter.hasNext()) {
                event = this.skeletonFilter.next();
                if (event.isTextUnit()) {
                    throw new OkapiMergeException(String.format("No corresponding text unit for id='%s' in the skeleton file.", event.getTextUnit().getId()));
                }
                this.writer.handleEvent(event);
            }
        }
        finally {
            this.writer.close();
        }
    }

    public void setWriter(IFilterWriter writer) {
        this.writer = writer;
    }

    public void setTextUnitMerger(ITextUnitMerger textUnitMerger) {
        this.textUnitMerger = textUnitMerger;
    }

    public IFilter getSkeletonFilter() {
        return this.skeletonFilter;
    }

    public void setSkeletonFilter(IFilter skeletonFilter) {
        this.skeletonFilter = skeletonFilter;
    }

    public ITextUnitMerger getTextUnitMerger() {
        return this.textUnitMerger;
    }
}

