/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.step;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.io.InputStreamFromOutputStream;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.merge.merge.SkeletonMergerWriter;

public class OriginalDocumentXliffMergerStep
extends BasePipelineStep {
    private IFilter filter;
    private IFilterConfigurationMapper fcMapper;
    private String outputEncoding;
    private LocaleId trgLoc;
    private RawDocument originalDocument;

    public String getName() {
        return "Original Document Xliff Merger";
    }

    public String getDescription() {
        return "Tkit merger which re-filters the original source file to provide the skeleton for merging.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.trgLoc = targetLocales.get(0);
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.originalDocument = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    protected Event handleRawDocument(final Event event) {
        this.filter = this.fcMapper.createFilter(this.originalDocument.getFilterConfigId(), this.filter);
        if (this.filter == null) {
            throw new OkapiFilterCreationException(String.format("Cannot create the filter or load the configuration for '%s'", this.originalDocument.getFilterConfigId()));
        }
        this.filter.open(this.originalDocument);
        final SkeletonMergerWriter skelMergerWriter = new SkeletonMergerWriter(this.filter, null);
        final XLIFFFilter xlfFilter = new XLIFFFilter();
        skelMergerWriter.setOptions(this.trgLoc, this.outputEncoding);
        InputStreamFromOutputStream<Void> is = new InputStreamFromOutputStream<Void>(){

            protected Void produce(OutputStream sink) throws Exception {
                try {
                    skelMergerWriter.setOutput(sink);
                    xlfFilter.open(event.getRawDocument());
                    while (xlfFilter.hasNext()) {
                        skelMergerWriter.handleEvent(xlfFilter.next());
                    }
                }
                catch (Exception e) {
                    this.close();
                    throw new OkapiMergeException("Error merging from original file", (Throwable)e);
                }
                finally {
                    if (xlfFilter != null) {
                        xlfFilter.close();
                    }
                    skelMergerWriter.close();
                    OriginalDocumentXliffMergerStep.this.originalDocument.close();
                }
                return null;
            }
        };
        return new Event(EventType.RAW_DOCUMENT, (IResource)new RawDocument((InputStream)is, this.outputEncoding, this.trgLoc));
    }

    public void cancel() {
    }

    public void destroy() {
    }
}

