/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsWriterStep;

public class MergerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Event> getTextUnitEvents(IFilter filter, RawDocument rd) {
        ArrayList<Event> list = new ArrayList<Event>();
        try {
            filter.open(rd);
            while (filter.hasNext()) {
                Event e = filter.next();
                if (!e.isTextUnit()) continue;
                list.add(e);
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
        }
        return list;
    }

    public static void writeXliffAndSkeleton(List<Event> events, String root, String path) {
        MergerUtil.writeXliffAndSkeleton(events, root, path, true);
    }

    public static void writeXliffAndSkeleton(List<Event> events, String root, String path, boolean writeSkeleton) {
        XLIFFWriter writer = new XLIFFWriter();
        writer.setOptions(LocaleId.SPANISH, "UTF-8");
        writer.setOutput(path);
        FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
        fewStep.setDocumentRoots(root);
        fewStep.setFilterWriter((IFilterWriter)writer);
        fewStep.setOutputURI(Util.toURI((String)path));
        fewStep.setOutputEncoding("UTF-8");
        fewStep.setLastOutputStep(true);
        fewStep.setTargetLocale(LocaleId.ENGLISH);
        XLIFFWriterParameters paramsXliff = (XLIFFWriterParameters)writer.getParameters();
        paramsXliff.setPlaceholderMode(true);
        for (Event event : events) {
            fewStep.handleEvent(event);
        }
        writer.close();
        fewStep.destroy();
    }
}

