/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra;

import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.lib.extra.Component;
import net.sf.okapi.lib.extra.IConfigurable;
import net.sf.okapi.lib.extra.INotifiable;

public abstract class OkapiComponent
extends Component
implements IConfigurable {
    private IParameters params;
    private String parametersClassName;

    protected abstract void component_init();

    protected void component_done() {
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = params;
        if (params instanceof INotifiable) {
            ((INotifiable)params).exec(this, "parameters_set_owner", this);
        }
        if (this instanceof INotifiable) {
            this.exec(this, "parameters_changed", null);
        }
        if (params == null) {
            return;
        }
        if (params.getClass() == null) {
            return;
        }
        this.parametersClassName = params.getClass().getName();
    }

    protected <A> A getParameters(Class<A> expectedClass) {
        if (this.params == null) {
            throw new OkapiBadFilterParametersException("Filter parameters object is null.");
        }
        if (!expectedClass.isInstance(this.params)) {
            String st = "null";
            if (this.params.getClass() != null) {
                st = this.params.getClass().getName();
            }
            throw new OkapiBadFilterParametersException(String.format("Parameters of class <%s> expected, but are <%s>", expectedClass.getName(), st));
        }
        return expectedClass.cast(this.params);
    }

    public String getParametersClassName() {
        return this.parametersClassName;
    }
}

