/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra;

import java.net.URL;
import java.util.List;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import net.sf.okapi.lib.extra.Component;
import net.sf.okapi.lib.extra.INotifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameters
extends StringParameters
implements INotifiable,
ISimplifierRulesParameters {
    protected Component owner = null;
    private String data;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractParameters() {
        this.parameters_init();
    }

    protected void parameters_init() {
    }

    protected abstract void parameters_reset();

    protected abstract void parameters_load(ParametersString var1);

    protected abstract void parameters_save(ParametersString var1);

    public final void reset() {
        this.parameters_reset();
    }

    public final void fromString(String data) {
        this.data = StringUtil.normalizeLineBreaks((String)data);
        super.fromString(this.data);
        this.parameters_load(this.buffer);
        this.setSimplifierRules(null);
        if (this.owner != null) {
            this.owner.exec(this, "parameters_changed", null);
        }
    }

    public final String toString() {
        this.buffer.reset();
        this.parameters_save(this.buffer);
        return super.toString();
    }

    @Override
    public boolean exec(Object sender, String command, Object info) {
        if (command.equalsIgnoreCase("parameters_set_owner")) {
            if (info instanceof Component) {
                this.owner = (Component)info;
            }
            return true;
        }
        return false;
    }

    public <T extends AbstractParameters> void loadGroup(ParametersString buffer, List<T> group, Class<T> elementClass) {
        if (elementClass == null) {
            return;
        }
        this.loadGroup(buffer, elementClass.getSimpleName(), group, elementClass);
    }

    public <T extends AbstractParameters> void loadGroup(ParametersString buffer, String groupName, List<T> group, Class<T> elementClass) {
        if (buffer == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (Util.isEmpty((String)groupName)) {
            return;
        }
        if (elementClass == null) {
            return;
        }
        group.clear();
        int count = buffer.getInteger(String.format("%sCount", groupName));
        for (int i = 0; i < count; ++i) {
            AbstractParameters item = null;
            try {
                item = (AbstractParameters)elementClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.debug("Group element instantiation failed: {}", (Object)e.getMessage());
                return;
            }
            if (item == null) {
                return;
            }
            item.parameters_load(new ParametersString(buffer.getGroup(String.format("%s%d", groupName, i))));
            group.add(item);
        }
        AbstractParameters item = (AbstractParameters)ListUtil.getFirstNonNullItem(group);
        if (item == null) {
            return;
        }
        if (item.owner != null) {
            item.owner.exec(group, "parameters_changed", null);
        }
    }

    public <T extends AbstractParameters> void saveGroup(ParametersString buffer, String groupName, List<T> group) {
        if (buffer == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (Util.isEmpty((String)groupName)) {
            return;
        }
        buffer.setInteger(String.format("%sCount", groupName), group.size());
        for (int i = 0; i < group.size(); ++i) {
            AbstractParameters item = (AbstractParameters)group.get(i);
            ParametersString tmp = new ParametersString();
            item.parameters_save(tmp);
            buffer.setGroup(String.format("%s%d", groupName, i), tmp.toString());
        }
    }

    public <T extends AbstractParameters> void saveGroup(ParametersString buffer, List<T> group, Class<T> elementClass) {
        if (elementClass == null) {
            return;
        }
        this.saveGroup(buffer, elementClass.getSimpleName(), group);
    }

    public boolean loadFromResource(String resourceLocation) {
        URL url = this.getClass().getResource(resourceLocation);
        if (url == null) {
            return false;
        }
        this.load(url, false);
        return true;
    }

    public boolean loadFromResource(Class<?> classRef, String resourceLocation) {
        if (classRef == null) {
            return this.loadFromResource(resourceLocation);
        }
        URL url = classRef.getResource(resourceLocation);
        if (url == null) {
            return false;
        }
        this.load(url, false);
        return true;
    }

    public void saveToResource(String resourceLocation) {
        URL url = this.getClass().getResource(resourceLocation);
        if (url == null) {
            return;
        }
        this.save(url.getPath());
    }

    public void saveToResource(Class<?> classRef, String resourceLocation) {
        if (classRef == null) {
            this.saveToResource(resourceLocation);
            return;
        }
        URL url = classRef.getResource(resourceLocation);
        if (url == null) {
            return;
        }
        this.save(url.getPath());
    }

    public String getData() {
        return this.data;
    }

    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

