/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.steps;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.lib.extra.steps.DocumentPartLogger;
import net.sf.okapi.lib.extra.steps.GroupLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuDpSgLogger
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private StringBuilder sb;
    private LocaleId srcLoc;
    private int index;

    public String getName() {
        return "Text Unit and Start Group Logger";
    }

    public String getDescription() {
        return "Logs Text Unit and Start Group resources going through the pipeline.";
    }

    protected Event handleStartBatch(Event event) {
        this.sb = new StringBuilder("\n\n");
        return super.handleStartBatch(event);
    }

    protected Event handleStartDocument(Event event) {
        StartDocument sd = (StartDocument)event.getResource();
        this.srcLoc = sd.getLocale();
        this.index = 0;
        return super.handleStartDocument(event);
    }

    protected Event handleTextUnit(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        ITextUnit tu = event.getTextUnit();
        this.sb.append(TextUnitLogger.getTuInfo(tu, this.srcLoc));
        return super.handleTextUnit(event);
    }

    protected Event handleDocumentPart(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        DocumentPart dp = event.getDocumentPart();
        this.sb.append(DocumentPartLogger.getDpInfo(dp, this.srcLoc));
        return super.handleDocumentPart(event);
    }

    protected Event handleStartGroup(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        StartGroup sg = event.getStartGroup();
        this.sb.append(GroupLogger.getSgInfo(sg, this.srcLoc));
        return super.handleStartGroup(event);
    }

    protected Event handleEndGroup(Event event) {
        this.sb.append(this.index++);
        this.sb.append("=========== \n");
        Ending eg = event.getEndGroup();
        this.sb.append(GroupLogger.getEgInfo(eg, this.srcLoc));
        return super.handleEndGroup(event);
    }

    protected Event handleEndBatch(Event event) {
        this.logger.trace(this.sb.toString());
        return super.handleEndBatch(event);
    }
}

