/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.diff.incava;

import java.util.List;
import java.util.Map;
import net.sf.okapi.lib.extra.diff.incava.DiffLists;
import net.sf.okapi.lib.extra.diff.incava.Difference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DiffTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testStrings1() {
        Object[] a = new String[]{"a", "b", "c", "e", "h", "j", "l", "m", "n", "p"};
        Object[] b = new String[]{"b", "c", "d", "e", "f", "j", "k", "l", "m", "r", "s", "t"};
        Difference[] expected = new Difference[]{new Difference(0, 0, 0, -1), new Difference(3, -1, 2, 2), new Difference(4, 4, 4, 4), new Difference(6, -1, 6, 6), new Difference(8, 9, 9, 11)};
        DiffLists d = new DiffLists(a, b);
        List diffs = d.diff();
        int i = 0;
        for (Difference diff : diffs) {
            Assert.assertEquals((Object)expected[i++], (Object)diff);
        }
    }

    @Test
    public void testStrings2() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        Object[] b = new String[]{"c", "d"};
        Difference[] expected = new Difference[]{new Difference(0, 1, 0, -1)};
        DiffLists d = new DiffLists(a, b);
        List diffs = d.diff();
        int i = 0;
        for (Difference diff : diffs) {
            Assert.assertEquals((Object)expected[i++], (Object)diff);
        }
    }

    @Test
    public void testStrings3() {
        Object[] a = new String[]{"a", "b", "c", "d", "x", "y", "z"};
        Object[] b = new String[]{"c", "d"};
        Difference[] expected = new Difference[]{new Difference(0, 1, 0, -1), new Difference(4, 6, 2, -1)};
        DiffLists d = new DiffLists(a, b);
        List diffs = d.diff();
        int i = 0;
        for (Difference diff : diffs) {
            Assert.assertEquals((Object)expected[i++], (Object)diff);
        }
    }

    @Test
    public void testStrings4() {
        Object[] a = new String[]{"a", "b", "c", "d", "e"};
        Object[] b = new String[]{"a", "x", "y", "b", "c", "j", "e"};
        Difference[] expected = new Difference[]{new Difference(1, -1, 1, 2), new Difference(3, 3, 5, 5)};
        DiffLists d = new DiffLists(a, b);
        List diffs = d.diff();
        int i = 0;
        for (Difference diff : diffs) {
            Assert.assertEquals((Object)expected[i++], (Object)diff);
        }
    }

    @Test
    public void testInteger() {
        Object[] a = new Integer[]{1, 2, 3};
        Object[] b = new Integer[]{2, 3};
        Difference[] expected = new Difference[]{new Difference(0, 0, 0, -1)};
        DiffLists d = new DiffLists(a, b);
        List diffs = d.diff();
        int i = 0;
        for (Difference diff : diffs) {
            Assert.assertEquals((Object)expected[i++], (Object)diff);
        }
    }

    @Test
    public void testStringsMatches() {
        Object[] a = new String[]{"a", "b", "c", "d", "e"};
        Object[] b = new String[]{"a", "x", "y", "b", "c", "j", "e"};
        DiffLists d = new DiffLists(a, b);
        Map matches = d.getMatches();
        Assert.assertEquals((long)0L, (long)((Integer)matches.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)matches.get(1)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)matches.get(2)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)matches.get(4)).intValue());
    }

    @Test
    public void testIntegerMatches() {
        Object[] a = new Integer[]{1, 2, 3};
        Object[] b = new Integer[]{2, 3};
        DiffLists d = new DiffLists(a, b);
        Map matches = d.getMatches();
        Assert.assertEquals((long)0L, (long)((Integer)matches.get(1)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)matches.get(2)).intValue());
    }
}

