/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.beans.v1.InputStreamBean;
import net.sf.okapi.lib.beans.v1.ZipEntryBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class ZipFileBean
extends PersistenceBean<ZipFile> {
    private String name;
    private List<ZipEntryBean> entries = new ArrayList<ZipEntryBean>();
    private boolean empty = true;

    protected ZipFile createObject(IPersistenceSession session) {
        if (Util.isEmpty((String)this.name) || this.empty) {
            return null;
        }
        File tempZip = null;
        try {
            tempZip = File.createTempFile("~okapi-32_ZipFileBean_", ".zip");
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
        if (tempZip.exists()) {
            tempZip.delete();
        }
        try {
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(tempZip.getAbsolutePath()));
            for (ZipEntryBean entryBean : this.entries) {
                ZipEntry entry = (ZipEntry)entryBean.get(ZipEntry.class, session);
                zipOut.putNextEntry(entry);
                if (entryBean.getInputStream() != null) {
                    zipOut.write(entryBean.getInputStream().getData());
                }
                zipOut.closeEntry();
            }
            zipOut.close();
        }
        catch (FileNotFoundException e1) {
            throw new OkapiException((Throwable)e1);
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(tempZip);
        }
        catch (ZipException e) {
            throw new OkapiException((Throwable)e);
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
        return zipFile;
    }

    protected void fromObject(ZipFile obj, IPersistenceSession session) {
        if (obj == null) {
            return;
        }
        this.name = Util.getFilename((String)obj.getName(), (boolean)true);
        try {
            ZipFile zipFile;
            obj = zipFile = new ZipFile(obj.getName());
            session.registerEndTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        throw new OkapiIOException((Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
        Enumeration<? extends ZipEntry> e = obj.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            ZipEntryBean entryBean = new ZipEntryBean();
            entryBean.set(entry, session);
            InputStreamBean isBean = entryBean.getInputStream();
            try {
                isBean.set(obj.getInputStream(entry), session);
            }
            catch (IOException e1) {
                throw new OkapiIOException((Throwable)e1);
            }
            this.entries.add(entryBean);
        }
        this.empty = Util.isEmpty((String)this.name) || Util.isEmpty(this.entries);
    }

    protected void setObject(ZipFile obj, IPersistenceSession session) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ZipEntryBean> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ZipEntryBean> entries) {
        this.entries = entries;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }
}

