/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.BaseNameable;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.beans.v1.BaseNameableBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class StartDocumentBean
extends BaseNameableBean {
    private String locale;
    private String encoding;
    private boolean isMultilingual;
    private FactoryBean filterParameters = new FactoryBean();
    private FactoryBean filterWriter = new FactoryBean();
    private boolean hasUTF8BOM;
    private String lineBreak;

    @Override
    protected BaseNameable createObject(IPersistenceSession session) {
        return new StartDocument(super.getId());
    }

    @Override
    protected void fromObject(BaseNameable obj, IPersistenceSession session) {
        super.fromObject(obj, session);
        if (obj instanceof StartDocument) {
            StartDocument sd = (StartDocument)obj;
            LocaleId loc = sd.getLocale();
            if (loc != null) {
                this.locale = loc.toString();
            }
            this.encoding = sd.getEncoding();
            this.isMultilingual = sd.isMultilingual();
            this.filterParameters.set((Object)sd.getFilterParameters(), session);
            this.filterWriter.set((Object)sd.getFilterWriter(), session);
            this.hasUTF8BOM = sd.hasUTF8BOM();
            this.lineBreak = sd.getLineBreak();
        }
    }

    @Override
    protected void setObject(BaseNameable obj, IPersistenceSession session) {
        super.setObject(obj, session);
        if (obj instanceof StartDocument) {
            StartDocument sd = (StartDocument)obj;
            sd.setLocale(LocaleId.fromString((String)this.locale));
            sd.setEncoding(this.encoding, this.hasUTF8BOM);
            sd.setMultilingual(this.isMultilingual);
            sd.setFilterParameters((IParameters)this.filterParameters.get(IParameters.class, session));
            sd.setFilterWriter((IFilterWriter)this.filterWriter.get(IFilterWriter.class, session));
            sd.setLineBreak(this.lineBreak);
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isMultilingual() {
        return this.isMultilingual;
    }

    public void setMultilingual(boolean isMultilingual) {
        this.isMultilingual = isMultilingual;
    }

    public FactoryBean getFilterWriter() {
        return this.filterWriter;
    }

    public void setFilterWriter(FactoryBean filterWriter) {
        this.filterWriter = filterWriter;
    }

    public boolean isHasUTF8BOM() {
        return this.hasUTF8BOM;
    }

    public void setHasUTF8BOM(boolean hasUTF8BOM) {
        this.hasUTF8BOM = hasUTF8BOM;
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public void setFilterParameters(FactoryBean filterParameters) {
        this.filterParameters = filterParameters;
    }

    public FactoryBean getFilterParameters() {
        return this.filterParameters;
    }
}

