/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v0;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.beans.v0.IPersistenceBean;
import net.sf.okapi.lib.beans.v0.IPersistenceSession;
import net.sf.okapi.lib.beans.v0.PersistenceMapper;

@Deprecated
public class JSONPersistenceSession
implements IPersistenceSession {
    public static final String MIME_TYPE = "application/json";
    private ObjectMapper mapper;
    private JsonFactory jsonFactory;
    private JsonParser parser;
    private OutputStream outStream;
    private InputStream inStream;
    private boolean isActive;
    private Class<?> rootClass;
    private Class<? extends IPersistenceBean> beanClass;

    public JSONPersistenceSession(Class<?> rootClass) {
        this.rootClass = rootClass;
        this.beanClass = PersistenceMapper.getBeanClass(rootClass);
    }

    public JSONPersistenceSession(Class<?> rootClass, OutputStream outStream) {
        this(rootClass);
        this.start(outStream);
    }

    public JSONPersistenceSession(Class<?> rootClass, InputStream inStream) {
        this(rootClass);
        this.start(inStream);
    }

    @Override
    public <T> T convert(Object object, Class<T> expectedClass) {
        return (T)this.mapper.convertValue(object, expectedClass);
    }

    @Override
    public Object deserialize() {
        if (!this.isActive) {
            return null;
        }
        IPersistenceBean bean = null;
        try {
            bean = (IPersistenceBean)this.mapper.readValue(this.parser, this.beanClass);
            bean.init(this);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bean.get(this.rootClass);
    }

    @Override
    public void end() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inStream = null;
        this.outStream = null;
        this.mapper = null;
    }

    @Override
    public void serialize(Object obj) {
        if (!this.isActive) {
            return;
        }
        if (!this.rootClass.isInstance(obj)) {
            throw new IllegalArgumentException(String.format("JSONPersistenceSession: unable to serialize %s, this session handles only %s", ClassUtil.getQualifiedClassName((Object)obj), ClassUtil.getQualifiedClassName(this.rootClass)));
        }
        IPersistenceBean bean = PersistenceMapper.getBean(this.rootClass);
        bean.init(this);
        bean.set(obj);
        try {
            this.mapper.writeValue(this.outStream, (Object)bean);
        }
        catch (JsonGenerationException e) {
            throw new OkapiException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new OkapiException((Throwable)e);
        }
        catch (IOException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    @Override
    public void start(OutputStream outStream) {
        this.end();
        this.outStream = outStream;
        this.startSession();
    }

    private void startSession() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.jsonFactory = this.mapper.getJsonFactory();
        this.isActive = true;
    }

    @Override
    public void start(InputStream inStream) {
        this.end();
        this.inStream = inStream;
        this.startSession();
        try {
            this.parser = this.jsonFactory.createJsonParser(inStream);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }
}

